#pragma once

//! @file Mix/Scene/IMotionController.h
//! @brief [VRg[[C^[tF[XCN|ht@C

#include "Mix/Reference.h"

namespace Mix{ namespace Scene{

	//! @class IMotionController
	//! @brief [VRg[[C^[tF[X
	class IMotionController : public Mix::Reference
	{
	protected:
		//! @brief fXgN^
		virtual ~IMotionController( void ) {}

	public:
		//! @brief O擾܂
		//! @return OԂ܂
		virtual const wchar_t* GetName( void ) const = 0;

		//! @brief vCIeB擾܂
		//! @return vCIeBԂ܂
		virtual UInt32 GetPriority( void ) const = 0;

		//! @brief [Ṽnh擾܂
		//! @return [Ṽnh擾܂B
		virtual UInt32 GetHandleCount( void ) const = 0;
		//! @brief [Ṽnh擾܂
		//! @param[in] index [ṼCfbNX
		//! @return [Ṽnh\ Mix::Scene::MOTION_HANDLE \̂Ԃ܂
		virtual Mix::Scene::MOTION_HANDLE GetHandleByIndex( UInt32 index ) const = 0;
		//! @brief [Ṽnh擾܂
		//! @param[in] pName [V̖O
		//! @return [Ṽnh\ Mix::Scene::MOTION_HANDLE \̂Ԃ܂
		virtual Mix::Scene::MOTION_HANDLE GetHandleByName( const wchar_t* pName ) const = 0;
		//! @brief [Vǉ܂
		//! @param[in] pMotion ǉ郂[V\ Mix::Scene::IMotion C^[tF[X̃|C^
		//! @return [Ṽnh\ Mix::Scene::MOTION_HANDLE \̂Ԃ܂
		//! @note ǉɐꍇA[V̎QƃJE^ +1 ܂
		virtual Mix::Scene::MOTION_HANDLE Add( Mix::Scene::IMotion* pMotion ) = 0;
		//! @brief [V폜܂
		//! @param[in] handle [Ṽnh\ Mix::Scene::MOTION_HANDLE \
		//! @return 폜ɐꍇ True Ԃ܂
		//! @note 폜ɐꍇA[V̎QƃJE^ -1 ܂
		virtual Boolean Remove( const Mix::Scene::MOTION_HANDLE& handle ) = 0;
		//! @brief [V擾܂
		//! @param[in] handle 擾郂[Ṽnh\ Mix::Scene::MOTION_HANDLE \
		//! @param[out] ppMotion 擾[Vn Mix::Scene::IMotion C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ́A[V̎QƃJE^ +1 ܂
		virtual Boolean Get( const Mix::Scene::MOTION_HANDLE& handle, Mix::Scene::IMotion** ppMotion ) = 0;

		//! @brief [VXe[g擾܂
		//! @param[in] handle 擾郂[VXe[g̃nh\ Mix::Scene::MOTION_HANDLE \
		//! @param[out] ppMotionState 擾[VXe[gn Mix::Scene::IMotionState C^[tF[X̃|C^̃AhX
		//! @return ꍇ True Ԃ܂
		//! @note 擾ɐꍇ́A[VXe[g̎QƃJE^ +1 ܂
		virtual Boolean GetState( const Mix::Scene::MOTION_HANDLE& handle, Mix::Scene::IMotionState** ppMotionState ) = 0;

		//! @brief SẴ[VɃXi[ݒ肵܂
		//! @param[in] pListener ݒ肷郊Xi[\ Mix::Scene::IMotionListener C^[tF[X̃|C^
		//! @note pListener  NULL w肷邱ƂŃXi[邱Ƃł܂
		virtual void SetListener( Mix::Scene::IMotionListener* pListener ) = 0;
		//! @brief [VɃXi[ݒ肵܂
		//! @param[in] handle Xi[ݒ肷郂[Ṽnh
		//! @param[in] pListener ݒ肷郊Xi[\ Mix::Scene::IMotionListener C^[tF[X̃|C^
		//! @return ꍇ True Ԃ܂
		//! @note pListener  NULL w肷邱ƂŃXi[邱Ƃł܂
		virtual Boolean SetListener( const Mix::Scene::MOTION_HANDLE& handle, Mix::Scene::IMotionListener* pListener ) = 0;

		//! @brief R}h𑗐M܂
		//! @param[in] exeType R}h̎s^Cv\ Mix::Scene::MOTION_COMMAND_EXECUTE_TYPE 񋓒萔
		//! @param[in] com R}h\ Mix::Scene::MOTION_COMMAND \
		//! @note R}h͍őR܂őҋ@邱ƂłA󂫂ꍇ́AŌ(R)̃R}h㏑܂B
		virtual void SendCommand( Mix::Scene::MOTION_COMMAND_EXECUTE_TYPE exeType, const Mix::Scene::MOTION_COMMAND& com ) = 0;
		//! @brief ҋ@̃R}h擾܂
		//! @return R}hԂ܂
		virtual UInt32 GetCommandCount( void ) const = 0;
	};

}}
