#pragma once

//! @file Mix/Scene/IPlanter.h
//! @brief v^[C^[tF[XCN[ht@C

#include "Mix/Scene/IWidget.h"
#include "Mix/Geometry/AABB.h"

namespace Mix{ namespace Scene{

	//! @class IPlanter
	//! @brief v^[C^[tF[X
	class IPlanter : public Mix::Scene::IWidget
	{
	public:
		//! @struct UNIT
		//! @brief jbg\
		struct UNIT
		{
			Mix::Matrix4x4 worldMat;	//!< [hs\ Mix::Matrix4x4 NX
			UInt32 modelIndex;			//!< f( GRASS_MODEL \̂̔z )̃CfbNX
		};

	protected:
		//! @brief fXgN^
		virtual ~IPlanter( void ) {}

	public:
		//! @brief [hs擾܂
		//! @return [hsԂ܂B
		virtual const Mix::Matrix4x4& GetWorldMatrix( void ) const = 0;
		//! @brief [hsݒ肵܂
		//! @param[in] worldMat [hs\ Mix::Matrix4x4 NX
		virtual void SetWorldMatrix( const Mix::Matrix4x4& worldMat ) = 0;

		//! @brief jbg̐擾܂
		//! @return jbg̐Ԃ܂B
		virtual UInt32 GetUnitCount( void ) const = 0;
		//! @brief jbg擾܂
		//! @param[in] index jbg̃CfbNX
		//! @return jbg\ Mix::Scene::IPlanter::UNIT \̂Ԃ܂B
		virtual const Mix::Scene::IPlanter::UNIT& GetUnit( UInt32 index ) const = 0;
		//! @brief jbgݒ肵܂
		//! @param[in] index ݒ肷郆jbg̃CfbNX
		//! @param[in] unit ݒ肷郆jbg\ Mix::Scene::IPlanter::UNIT \
		//! @return ꍇ True Ԃ܂
		virtual Boolean SetUnit( UInt32 index, const Mix::Scene::IPlanter::UNIT& unit ) = 0;
		//! @brief jbgǉ܂
		//! @param[in] unit ǉ郆jbg\ Mix::Scene::IPlanter::UNIT \
		//! @return ꍇ True Ԃ܂
		virtual Boolean AddUnit( const Mix::Scene::IPlanter::UNIT& unit ) = 0;
		//! @brief jbg폜܂
		//! @param[in] index 폜郆jbg̃CfbNX
		//! @return ꍇ True Ԃ܂
		virtual Boolean RemoveUnit( UInt32 index ) = 0;
		//! @brief SẴjbg폜܂
		virtual void ClearUnits( void ) = 0;

		//! @brief tbV܂
		//! @note
		//! [hs̍ېݒAjbg̒ǉA폜ȂǂsۂɎsĂB<br>
		//! ܂Ã\bh͕s邱Ƃł܂B
		virtual void Refresh( void ) = 0;

		//! @brief E擾܂
		//! @return E\ Mix::Geometry::AABB Ԃ܂
		virtual const Mix::Geometry::AABB& GetBounds( void ) const = 0;

		//! @brief OǂmF܂
		//! @return Ȍꍇ True Ԃ܂
		//! @note OƂ͕`攻Ɏgp锪؂͈̔͂𒴂ĔzuĂԂ̂Ƃ\܂B
		virtual Boolean IsIgnored( void ) const = 0;
	};

}}
