#pragma once

//! @file Mix/Scene/IPointLight.h
//! @brief |CgCgC^[tF[XCN[ht@C

#include "Mix/Scene/ILocalLight.h"

namespace Mix{ namespace Scene{

	//! @class IPointLight
	//! @brief |CgCgC^[tF[X
	class IPointLight : public Mix::Scene::ILocalLight
	{
	protected:
		//! @brief fXgN^
		virtual ~IPointLight( void ){}

	public:
		//! @brief Cg͂ŏa擾܂
		//! @return Cg͂ŏa
		virtual Float32 GetInnerRadius( void ) const = 0;
		//! @brief Cg͂ŏa擾܂
		//! @return Cg͂ŏa
		virtual Float32 GetOuterRadius( void ) const = 0;
		//! @brief Cg͂aݒ肵܂
		//! @param[in] innerRadius Cg̓͂ŏa( 0.0f`̖ )
		//! @param[in] outerRadius Cg̓͂ő唼a( 0.0f`̖ )
		//! @note innerRadius <= outerRadius łKv܂
		virtual void SetRadius( Float32 innerRadius, Float32 outerRadius ) = 0;
	};

}}
