#pragma once

//! @file Mix/Scene/IScatterParticle.h
//! @brief XLb^[p[eBNC^[tF[XCN[ht@C

#include "Mix/Scene/IParticle.h"

namespace Mix{ namespace Scene{

	//! @class IScatterParticle
	//! @brief XLb^[p[eBNC^[tF[X
	//! @note
	//! Uz^Cṽp[eBNɂȂ܂B<br>
	//! JnʂɐڐGۂ̎Ȃǂ̏A̒ZL͈͂ɂ킽\ȂǂɍœKłB
	class IScatterParticle : public Mix::Scene::IParticle
	{
	public:
		//! @struct STATE
		//! @brief Xe[g\
		struct STATE
		{
			UInt32 unitCount;		//!< jbg
			UInt32 unitCapacity;	//!< jbg̃LpVeB

			UInt32 quadCount;		//!< Nbh̐
			UInt32 quadCapacity;	//!< Nbh̐
		};

	protected:
		//! @brief fXgN^
		virtual ~IScatterParticle( void ) {}

	public:
		//! @brief ĂSẴjbgNA܂
		virtual void Clear( void ) = 0;

		//! @brief jbg𔭐܂
		//! @param[in] worldMat jbg̃[hgXtH[\ Mix::Matrix4x4 NX
		virtual void Emit( const Mix::Matrix4x4& worldMat ) = 0;
		//! @brief jbg𔭐܂
		//! @param[in] worldMat jbg̃[hgXtH[\ Mix::Matrix4x4 NX
		//! @param[in] genNum 鐔
		virtual void Emit( const Mix::Matrix4x4& worldMat, UInt32 genNum ) = 0;

		//! @brief Xe[^X擾܂
		//! @return Xe[^X\ Mix::Scene::IScatterParticle::STATE \̂Ԃ܂
		virtual const Mix::Scene::IScatterParticle::STATE& GetState( void ) const = 0;
	};

}}
