@echo off

if "%PROCESSOR_ARCHITECTURE%" == "x86" (
  set MIX_PLATFORM_TARGET=x86
) else (
  set MIX_PLATFORM_TARGET=x64
)

PATH=..\Vendor\DirectX\Utilities\bin\%MIX_PLATFORM_TARGET%;..\Utilities;%PATH%

set MIX_DIR_G=Graphics
set MIX_DIR_GU=Graphics\Utility
set MIX_DIR_SC_MISC=Scene\Common\Misc
set MIX_DIR_SC_PE=Scene\Common\PostEffect
set MIX_DIR_SS_PE=Scene\Standard\PostEffect
set MIX_DIR_SS_SKYDOME=Scene\Standard\SkyDome

set MIX_SRC_DIR_G=Source\%MIX_DIR_G%
set MIX_SRC_DIR_GU=Source\%MIX_DIR_GU%
set MIX_SRC_DIR_SC_MISC=Source\%MIX_DIR_SC_MISC%
set MIX_SRC_DIR_SC_PE=Source\%MIX_DIR_SC_PE%
set MIX_SRC_DIR_SS_PE=Source\%MIX_DIR_SS_PE%
set MIX_SRC_DIR_SS_SKYDOME=Source\%MIX_DIR_SS_SKYDOME%

set MIX_OBJ_DIR_G=Objects\Runtime\Mix\%MIX_SM%\%MIX_DIR_G%
set MIX_OBJ_DIR_GU=Objects\Runtime\Mix\%MIX_SM%\%MIX_DIR_GU%
set MIX_OBJ_DIR_SC_MISC=Objects\Runtime\Mix\%MIX_SM%\%MIX_DIR_SC_MISC%
set MIX_OBJ_DIR_SC_PE=Objects\Runtime\Mix\%MIX_SM%\%MIX_DIR_SC_PE%
set MIX_OBJ_DIR_SS_PE=Objects\Runtime\Mix\%MIX_SM%\%MIX_DIR_SS_PE%
set MIX_OBJ_DIR_SS_SKYDOME=Objects\Runtime\Mix\%MIX_SM%\%MIX_DIR_SS_SKYDOME%

rem Objects - Directory

if "%MIX_SM%" neq "MIX_SM_3" (
  if not exist %MIX_OBJ_DIR_G% ( mkdir %MIX_OBJ_DIR_G% )
)

if not exist %MIX_OBJ_DIR_GU% ( mkdir %MIX_OBJ_DIR_GU% )
if not exist %MIX_OBJ_DIR_SC_MISC% ( mkdir %MIX_OBJ_DIR_SC_MISC% )
if not exist %MIX_OBJ_DIR_SC_PE% ( mkdir %MIX_OBJ_DIR_SC_PE% )
if not exist %MIX_OBJ_DIR_SS_PE% ( mkdir %MIX_OBJ_DIR_SS_PE% )
if not exist %MIX_OBJ_DIR_SS_SKYDOME% ( mkdir %MIX_OBJ_DIR_SS_SKYDOME% )

rem Release - Directory

if "%MIX_SM%" neq "MIX_SM_3" ( 
  if not exist %MIX_DST_DIR_G% ( mkdir "%MIX_DST_DIR_G%" )
)

if not exist %MIX_DST_DIR_GU% ( mkdir "%MIX_DST_DIR_GU%" )
if not exist %MIX_DST_DIR_SC_MISC% ( mkdir "%MIX_DST_DIR_SC_MISC%" )
if not exist %MIX_DST_DIR_SC_PE% ( mkdir "%MIX_DST_DIR_SC_PE%" )
if not exist %MIX_DST_DIR_SS_PE% ( mkdir "%MIX_DST_DIR_SS_PE%" )
if not exist %MIX_DST_DIR_SS_SKYDOME% ( mkdir "%MIX_DST_DIR_SS_SKYDOME%" )

rem Graphics

if "%MIX_SM%" neq "MIX_SM_3" (
    fxc.exe /nologo /E "main" /T "%MIX_VS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_G%\present.vs" "%MIX_SRC_DIR_G%\present.vs.txt"
    if errorlevel 1 ( goto ERROR )
    fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_G%\present.ps" "%MIX_SRC_DIR_G%\present.ps.txt"
    if errorlevel 1 ( goto ERROR )

    BinToTxt.exe /i "%MIX_OBJ_DIR_G%\present.vs" /o "%MIX_DST_DIR_G%\present.vs.inc" /h 8 /t 1
    if errorlevel 1 ( goto ERROR )
    BinToTxt.exe /i "%MIX_OBJ_DIR_G%\present.ps" /o "%MIX_DST_DIR_G%\present.ps.inc" /h 8 /t 1
    if errorlevel 1 ( goto ERROR )
)

rem Graphics - Utility

fxc.exe /nologo /E "main"                /T "%MIX_VS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_GU%\canvas.vs"                "%MIX_SRC_DIR_GU%\canvas.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainColor"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_GU%\canvasColor.ps"           "%MIX_SRC_DIR_GU%\canvas.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainColorAndTexture" /T "%MIX_PS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_GU%\canvasColorAndTexture.ps" "%MIX_SRC_DIR_GU%\canvas.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"                /T "%MIX_VS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_GU%\line.vs"                  "%MIX_SRC_DIR_GU%\line.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"                /T "%MIX_PS%" /D "%MIX_SM%"="1" /Fo "%MIX_OBJ_DIR_GU%\line.ps"                  "%MIX_SRC_DIR_GU%\line.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_OBJ_DIR_GU%\canvas.vs"                /o "%MIX_DST_DIR_GU%\canvas.vs.inc"                /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_GU%\canvasColor.ps"           /o "%MIX_DST_DIR_GU%\canvasColor.ps.inc"           /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_GU%\canvasColorAndTexture.ps" /o "%MIX_DST_DIR_GU%\canvasColorAndTexture.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_GU%\line.vs"                  /o "%MIX_DST_DIR_GU%\line.vs.inc"                  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_GU%\line.ps"                  /o "%MIX_DST_DIR_GU%\line.ps.inc"                  /h 8 /t 1
if errorlevel 1 ( goto ERROR )

rem Scene - Common - Misc

fxc.exe /nologo /E "main"        /T "%MIX_VS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\sampling.vs"       "%MIX_SRC_DIR_SC_MISC%\sampling.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainCopy"    /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\samplingCopy.ps"   "%MIX_SRC_DIR_SC_MISC%\sampling.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainDown2x"  /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\samplingDown2x.ps" "%MIX_SRC_DIR_SC_MISC%\sampling.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainDown4x"  /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\samplingDown4x.ps" "%MIX_SRC_DIR_SC_MISC%\sampling.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainX"       /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "AMOUNT"="2"                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\blur3x_X.ps"       "%MIX_SRC_DIR_SC_MISC%\blur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainY"       /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "AMOUNT"="2"                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\blur3x_Y.ps"       "%MIX_SRC_DIR_SC_MISC%\blur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainX"       /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "AMOUNT"="3"                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\blur5x_X.ps"       "%MIX_SRC_DIR_SC_MISC%\blur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainY"       /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "AMOUNT"="3"                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\blur5x_Y.ps"       "%MIX_SRC_DIR_SC_MISC%\blur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainX"       /T "%MIX_VS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_X.vs" "%MIX_SRC_DIR_SC_MISC%\gaussianBlur.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainY"       /T "%MIX_VS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_Y.vs" "%MIX_SRC_DIR_SC_MISC%\gaussianBlur.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainX"       /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_X.ps" "%MIX_SRC_DIR_SC_MISC%\gaussianBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainY"       /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_Y.ps" "%MIX_SRC_DIR_SC_MISC%\gaussianBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"        /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\gaussianBlurEx.ps" "%MIX_SRC_DIR_SC_MISC%\gaussianBlurEx.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"        /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                     /Fo "%MIX_OBJ_DIR_SC_MISC%\brightPass__.ps"   "%MIX_SRC_DIR_SC_MISC%\brightPass.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"        /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_LUM"="1"                                 /Fo "%MIX_OBJ_DIR_SC_MISC%\brightPassL_.ps"   "%MIX_SRC_DIR_SC_MISC%\brightPass.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"        /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_LUM"="1" /D "ENABLE_AUTO_MIDDLEGRAY"="1" /Fo "%MIX_OBJ_DIR_SC_MISC%\brightPassLA.ps"   "%MIX_SRC_DIR_SC_MISC%\brightPass.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\sampling.vs"       /o "%MIX_DST_DIR_SC_MISC%\sampling.vs.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\samplingCopy.ps"   /o "%MIX_DST_DIR_SC_MISC%\samplingCopy.ps.inc"   /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\samplingDown2x.ps" /o "%MIX_DST_DIR_SC_MISC%\samplingDown2x.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\samplingDown4x.ps" /o "%MIX_DST_DIR_SC_MISC%\samplingDown4x.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\blur3x_X.ps"       /o "%MIX_DST_DIR_SC_MISC%\blur3x_X.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\blur3x_Y.ps"       /o "%MIX_DST_DIR_SC_MISC%\blur3x_Y.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\blur5x_X.ps"       /o "%MIX_DST_DIR_SC_MISC%\blur5x_X.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\blur5x_Y.ps"       /o "%MIX_DST_DIR_SC_MISC%\blur5x_Y.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_X.vs" /o "%MIX_DST_DIR_SC_MISC%\gaussianBlur_X.vs.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_Y.vs" /o "%MIX_DST_DIR_SC_MISC%\gaussianBlur_Y.vs.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_X.ps" /o "%MIX_DST_DIR_SC_MISC%\gaussianBlur_X.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\gaussianBlur_Y.ps" /o "%MIX_DST_DIR_SC_MISC%\gaussianBlur_Y.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\gaussianBlurEx.ps" /o "%MIX_DST_DIR_SC_MISC%\gaussianBlurEx.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\brightPass__.ps"   /o "%MIX_DST_DIR_SC_MISC%\brightPass__.ps.inc"   /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\brightPassL_.ps"   /o "%MIX_DST_DIR_SC_MISC%\brightPassL_.ps.inc"   /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_MISC%\brightPassLA.ps"   /o "%MIX_DST_DIR_SC_MISC%\brightPassLA.ps.inc"   /h 8 /t 1
if errorlevel 1 ( goto ERROR )

rem Scene - Common - PostEfffect

fxc.exe /nologo /E "mainInital_4x"  /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lumTransform_Inital.ps"  "%MIX_SRC_DIR_SC_PE%\lumTransform.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainIterate_4x" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lumTransform_Iterate.ps" "%MIX_SRC_DIR_SC_PE%\lumTransform.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainFinal_4x"   /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lumTransform_Final.ps"   "%MIX_SRC_DIR_SC_PE%\lumTransform.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lumAdapted.ps"           "%MIX_SRC_DIR_SC_PE%\lumAdapted.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                             /D "ENABLE_BLUESHIFT"="1"                                 /Fo "%MIX_OBJ_DIR_SC_PE%\lumOperator__B.ps"       "%MIX_SRC_DIR_SC_PE%\lumOperator.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_TONEMAPPING"="1"                                                           /Fo "%MIX_OBJ_DIR_SC_PE%\lumOperatorT__.ps"       "%MIX_SRC_DIR_SC_PE%\lumOperator.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_TONEMAPPING"="1" /D "ENABLE_BLUESHIFT"="1"                                 /Fo "%MIX_OBJ_DIR_SC_PE%\lumOperatorT_B.ps"       "%MIX_SRC_DIR_SC_PE%\lumOperator.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_TONEMAPPING"="1" /D "ENABLE_AUTO_MIDDLEGRAY"="1"                           /Fo "%MIX_OBJ_DIR_SC_PE%\lumOperatorTA_.ps"       "%MIX_SRC_DIR_SC_PE%\lumOperator.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_TONEMAPPING"="1" /D "ENABLE_AUTO_MIDDLEGRAY"="1" /D "ENABLE_BLUESHIFT"="1" /Fo "%MIX_OBJ_DIR_SC_PE%\lumOperatorTAB.ps"       "%MIX_SRC_DIR_SC_PE%\lumOperator.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareImage__.ps"     "%MIX_SRC_DIR_SC_PE%\lensFlareImage.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                           /D "ENABLE_HALO"="1"                                        /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareImage_H.ps"     "%MIX_SRC_DIR_SC_PE%\lensFlareImage.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_GHOST_TEX"="1"                                                             /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareImageG_.ps"     "%MIX_SRC_DIR_SC_PE%\lensFlareImage.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_GHOST_TEX"="1" /D "ENABLE_HALO"="1"                                        /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareImageGH.ps"     "%MIX_SRC_DIR_SC_PE%\lensFlareImage.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareModify__.ps"    "%MIX_SRC_DIR_SC_PE%\lensFlareModify.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_DIRT"="1"                                                                  /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareModifyD_.ps"    "%MIX_SRC_DIR_SC_PE%\lensFlareModify.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                      /D "ENABLE_BRUST"="1"                                            /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareModify_B.ps"    "%MIX_SRC_DIR_SC_PE%\lensFlareModify.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_DIRT"="1" /D "ENABLE_BRUST"="1"                                            /Fo "%MIX_OBJ_DIR_SC_PE%\lensFlareModifyDB.ps"    "%MIX_SRC_DIR_SC_PE%\lensFlareModify.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\filmicHejl.ps"           "%MIX_SRC_DIR_SC_PE%\filmicHejl.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\filmicHable.ps"          "%MIX_SRC_DIR_SC_PE%\filmicHable.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\gamma.ps"                "%MIX_SRC_DIR_SC_PE%\gamma.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\lensDistortion_.ps"      "%MIX_SRC_DIR_SC_PE%\lensDistortion.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_K_CUBE"="1"                                                                /Fo "%MIX_OBJ_DIR_SC_PE%\lensDistortionK.ps"      "%MIX_SRC_DIR_SC_PE%\lensDistortion.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\vignette.ps"             "%MIX_SRC_DIR_SC_PE%\vignette.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"           /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                       /Fo "%MIX_OBJ_DIR_SC_PE%\fxaa.ps"                 "%MIX_SRC_DIR_SC_PE%\fxaa.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumTransform_Inital.ps"  /o "%MIX_DST_DIR_SC_PE%\lumTransform_Inital.ps.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumTransform_Iterate.ps" /o "%MIX_DST_DIR_SC_PE%\lumTransform_Iterate.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumTransform_Final.ps"   /o "%MIX_DST_DIR_SC_PE%\lumTransform_Final.ps.inc"   /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumAdapted.ps"           /o "%MIX_DST_DIR_SC_PE%\lumAdapted.ps.inc"           /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumOperator__B.ps"       /o "%MIX_DST_DIR_SC_PE%\lumOperator__B.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumOperatorT__.ps"       /o "%MIX_DST_DIR_SC_PE%\lumOperatorT__.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumOperatorT_B.ps"       /o "%MIX_DST_DIR_SC_PE%\lumOperatorT_B.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumOperatorTA_.ps"       /o "%MIX_DST_DIR_SC_PE%\lumOperatorTA_.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lumOperatorTAB.ps"       /o "%MIX_DST_DIR_SC_PE%\lumOperatorTAB.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareImage__.ps"     /o "%MIX_DST_DIR_SC_PE%\lensFlareImage__.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareImage_H.ps"     /o "%MIX_DST_DIR_SC_PE%\lensFlareImage_H.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareImageG_.ps"     /o "%MIX_DST_DIR_SC_PE%\lensFlareImageG_.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareImageGH.ps"     /o "%MIX_DST_DIR_SC_PE%\lensFlareImageGH.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareModify__.ps"    /o "%MIX_DST_DIR_SC_PE%\lensFlareModify__.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareModifyD_.ps"    /o "%MIX_DST_DIR_SC_PE%\lensFlareModifyD_.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareModify_B.ps"    /o "%MIX_DST_DIR_SC_PE%\lensFlareModify_B.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensFlareModifyDB.ps"    /o "%MIX_DST_DIR_SC_PE%\lensFlareModifyDB.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\filmicHejl.ps"           /o "%MIX_DST_DIR_SC_PE%\filmicHejl.ps.inc"           /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\filmicHable.ps"          /o "%MIX_DST_DIR_SC_PE%\filmicHable.ps.inc"          /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\gamma.ps"                /o "%MIX_DST_DIR_SC_PE%\gamma.ps.inc"                /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensDistortion_.ps"      /o "%MIX_DST_DIR_SC_PE%\lensDistortion_.ps.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\lensDistortionK.ps"      /o "%MIX_DST_DIR_SC_PE%\lensDistortionK.ps.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\vignette.ps"             /o "%MIX_DST_DIR_SC_PE%\vignette.ps.inc"             /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SC_PE%\fxaa.ps"                 /o "%MIX_DST_DIR_SC_PE%\fxaa.ps.inc"                 /h 8 /t 1
if errorlevel 1 ( goto ERROR )

rem Scene - Standard - PostEfffect

fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\ssao.ps"             "%MIX_SRC_DIR_SS_PE%\ssao.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "USE_NOISE_TEX"="1"                        /Fo "%MIX_OBJ_DIR_SS_PE%\ssao_tex.ps"         "%MIX_SRC_DIR_SS_PE%\ssao.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\smFinish___.ps"      "%MIX_SRC_DIR_SS_PE%\smFinish.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                         /D "ENABLE_BOKEH"="1" /Fo "%MIX_OBJ_DIR_SS_PE%\smFinish__B.ps"      "%MIX_SRC_DIR_SS_PE%\smFinish.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_REFRACT"="1"                       /Fo "%MIX_OBJ_DIR_SS_PE%\smFinish_R_.ps"      "%MIX_SRC_DIR_SS_PE%\smFinish.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_REFRACT"="1" /D "ENABLE_BOKEH"="1" /Fo "%MIX_OBJ_DIR_SS_PE%\smFinish_RB.ps"      "%MIX_SRC_DIR_SS_PE%\smFinish.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\underWater.ps"       "%MIX_SRC_DIR_SS_PE%\underWater.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\lightShaftsInit_.ps" "%MIX_SRC_DIR_SS_PE%\lightShaftsInit.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_ACUITY_TEX"="1"                    /Fo "%MIX_OBJ_DIR_SS_PE%\lightShaftsInitA.ps" "%MIX_SRC_DIR_SS_PE%\lightShaftsInit.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "NUM_SAMPLES"="32"                         /Fo "%MIX_OBJ_DIR_SS_PE%\lightShaftsBlurL.ps" "%MIX_SRC_DIR_SS_PE%\lightShaftsBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "NUM_SAMPLES"="64"                         /Fo "%MIX_OBJ_DIR_SS_PE%\lightShaftsBlurM.ps" "%MIX_SRC_DIR_SS_PE%\lightShaftsBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "NUM_SAMPLES"="128"                        /Fo "%MIX_OBJ_DIR_SS_PE%\lightShaftsBlurH.ps" "%MIX_SRC_DIR_SS_PE%\lightShaftsBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "CMB_MAX_SAMPLES"="16"                     /Fo "%MIX_OBJ_DIR_SS_PE%\camMotionBlur_L.ps"  "%MIX_SRC_DIR_SS_PE%\camMotionBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "CMB_MAX_SAMPLES"="32"                     /Fo "%MIX_OBJ_DIR_SS_PE%\camMotionBlur_M.ps"  "%MIX_SRC_DIR_SS_PE%\camMotionBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "CMB_MAX_SAMPLES"="64"                     /Fo "%MIX_OBJ_DIR_SS_PE%\camMotionBlur_H.ps"  "%MIX_SRC_DIR_SS_PE%\camMotionBlur.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\caImage_.ps"         "%MIX_SRC_DIR_SS_PE%\caImage.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_K_CUBE"="1"                        /Fo "%MIX_OBJ_DIR_SS_PE%\caImageK.ps"         "%MIX_SRC_DIR_SS_PE%\caImage.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\caFinish_.ps"        "%MIX_SRC_DIR_SS_PE%\caFinish.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_DEPTH"="1"                         /Fo "%MIX_OBJ_DIR_SS_PE%\caFinishD.ps"        "%MIX_SRC_DIR_SS_PE%\caFinish.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                               /Fo "%MIX_OBJ_DIR_SS_PE%\depthOfField.ps"     "%MIX_SRC_DIR_SS_PE%\depthOfField.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\ssao.ps"             /o "%MIX_DST_DIR_SS_PE%\ssao.ps.inc"             /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\ssao_tex.ps"         /o "%MIX_DST_DIR_SS_PE%\ssao_tex.ps.inc"         /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\smFinish___.ps"      /o "%MIX_DST_DIR_SS_PE%\smFinish___.ps.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\smFinish__B.ps"      /o "%MIX_DST_DIR_SS_PE%\smFinish__B.ps.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\smFinish_R_.ps"      /o "%MIX_DST_DIR_SS_PE%\smFinish_R_.ps.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\smFinish_RB.ps"      /o "%MIX_DST_DIR_SS_PE%\smFinish_RB.ps.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\underWater.ps"       /o "%MIX_DST_DIR_SS_PE%\underWater.ps.inc"       /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\lightShaftsInit_.ps" /o "%MIX_DST_DIR_SS_PE%\lightShaftsInit_.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\lightShaftsInitA.ps" /o "%MIX_DST_DIR_SS_PE%\lightShaftsInitA.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\lightShaftsBlurL.ps" /o "%MIX_DST_DIR_SS_PE%\lightShaftsBlurL.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\lightShaftsBlurM.ps" /o "%MIX_DST_DIR_SS_PE%\lightShaftsBlurM.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\lightShaftsBlurH.ps" /o "%MIX_DST_DIR_SS_PE%\lightShaftsBlurH.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\camMotionBlur_L.ps"  /o "%MIX_DST_DIR_SS_PE%\camMotionBlur_L.ps.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\camMotionBlur_M.ps"  /o "%MIX_DST_DIR_SS_PE%\camMotionBlur_M.ps.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\camMotionBlur_H.ps"  /o "%MIX_DST_DIR_SS_PE%\camMotionBlur_H.ps.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\caImage_.ps"         /o "%MIX_DST_DIR_SS_PE%\caImage_.ps.inc"         /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\caImageK.ps"         /o "%MIX_DST_DIR_SS_PE%\caImageK.ps.inc"         /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\caFinish_.ps"        /o "%MIX_DST_DIR_SS_PE%\caFinish_.ps.inc"        /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\caFinishD.ps"        /o "%MIX_DST_DIR_SS_PE%\caFinishD.ps.inc"        /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_PE%\depthOfField.ps"     /o "%MIX_DST_DIR_SS_PE%\depthOfField.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )

rem Scene - Standard - SkyDome

fxc.exe /nologo /E "main" /T "%MIX_VS%" /D "%MIX_SM%"="1"                                                                                                                       /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default.vs"         "%MIX_SRC_DIR_SS_SKYDOME%\default.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                                                       /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default_____.ps"    "%MIX_SRC_DIR_SS_SKYDOME%\default.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                              /D "ENABLE_CLOUD_TEXTURE"="1"                                                            /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default__c__.ps"    "%MIX_SRC_DIR_SS_SKYDOME%\default.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                              /D "ENABLE_CLOUD_TEXTURE"="1" /D "ENABLE_CLOUD_LAYER"="1"                                /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default__c2_.ps"    "%MIX_SRC_DIR_SS_SKYDOME%\default.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1"                                                                                          /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default_b___.ps"    "%MIX_SRC_DIR_SS_SKYDOME%\default.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1" /D "ENABLE_CLOUD_TEXTURE"="1"                                                            /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default_bc__.ps"    "%MIX_SRC_DIR_SS_SKYDOME%\default.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1" /D "ENABLE_CLOUD_TEXTURE"="1" /D "ENABLE_CLOUD_LAYER"="1"                                /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\default_bc2_.ps"    "%MIX_SRC_DIR_SS_SKYDOME%\default.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_VS%" /D "%MIX_SM%"="1"                                                                                                                       /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere.vs"      "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                                                       /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_____.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                              /D "ENABLE_CLOUD_TEXTURE"="1"                                                            /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c__.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                              /D "ENABLE_CLOUD_TEXTURE"="1"                             /D "ENABLE_CLOUD_LIGHTING"="1" /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c_l.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                              /D "ENABLE_CLOUD_TEXTURE"="1" /D "ENABLE_CLOUD_LAYER"="1"                                /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c2_.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                              /D "ENABLE_CLOUD_TEXTURE"="1" /D "ENABLE_CLOUD_LAYER"="1" /D "ENABLE_CLOUD_LIGHTING"="1" /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c2l.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1"                                                                                          /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_b___.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1" /D "ENABLE_CLOUD_TEXTURE"="1"                                                            /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc__.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1" /D "ENABLE_CLOUD_TEXTURE"="1"                             /D "ENABLE_CLOUD_LIGHTING"="1" /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc_l.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1" /D "ENABLE_CLOUD_TEXTURE"="1" /D "ENABLE_CLOUD_LAYER"="1"                                /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc2_.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_BASE_TEXTURE"="1" /D "ENABLE_CLOUD_TEXTURE"="1" /D "ENABLE_CLOUD_LAYER"="1" /D "ENABLE_CLOUD_LIGHTING"="1" /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc2l.ps" "%MIX_SRC_DIR_SS_SKYDOME%\atmosphere.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_VS%" /D "%MIX_SM%"="1"                                                                                                                        /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\panorama.vs"        "%MIX_SRC_DIR_SS_SKYDOME%\panorama.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_VS%" /D "%MIX_SM%"="1" /D "ENABLE_FOG"="1" /D "ENABLE_ATMOSPHERE"="1"                                                                         /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\panorama_fa.vs"     "%MIX_SRC_DIR_SS_SKYDOME%\panorama.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1"                                                                                                                        /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\panorama.ps"        "%MIX_SRC_DIR_SS_SKYDOME%\panorama.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_FOG"="1"                                                                                                    /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\panorama_fd.ps"     "%MIX_SRC_DIR_SS_SKYDOME%\panorama.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main" /T "%MIX_PS%" /D "%MIX_SM%"="1" /D "ENABLE_FOG"="1" /D "ENABLE_ATMOSPHERE"="1"                                                                         /Fo "%MIX_OBJ_DIR_SS_SKYDOME%\panorama_fa.ps"     "%MIX_SRC_DIR_SS_SKYDOME%\panorama.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default.vs"         /o "%MIX_DST_DIR_SS_SKYDOME%\default.vs.inc"         /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default_____.ps"    /o "%MIX_DST_DIR_SS_SKYDOME%\default_____.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default__c__.ps"    /o "%MIX_DST_DIR_SS_SKYDOME%\default__c__.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default__c2_.ps"    /o "%MIX_DST_DIR_SS_SKYDOME%\default__c2_.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default_b___.ps"    /o "%MIX_DST_DIR_SS_SKYDOME%\default_b___.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default_bc__.ps"    /o "%MIX_DST_DIR_SS_SKYDOME%\default_bc__.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\default_bc2_.ps"    /o "%MIX_DST_DIR_SS_SKYDOME%\default_bc2_.ps.inc"    /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere.vs"      /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere.vs.inc"      /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_____.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere_____.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c__.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere__c__.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c_l.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere__c_l.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c2_.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere__c2_.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere__c2l.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere__c2l.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_b___.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere_b___.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc__.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere_bc__.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc_l.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere_bc_l.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc2_.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere_bc2_.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\atmosphere_bc2l.ps" /o "%MIX_DST_DIR_SS_SKYDOME%\atmosphere_bc2l.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\panorama.vs"        /o "%MIX_DST_DIR_SS_SKYDOME%\panorama.vs.inc"        /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\panorama_fa.vs"     /o "%MIX_DST_DIR_SS_SKYDOME%\panorama_fa.vs.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\panorama.ps"        /o "%MIX_DST_DIR_SS_SKYDOME%\panorama.ps.inc"        /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\panorama_fd.ps"     /o "%MIX_DST_DIR_SS_SKYDOME%\panorama_fd.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_OBJ_DIR_SS_SKYDOME%\panorama_fa.ps"     /o "%MIX_DST_DIR_SS_SKYDOME%\panorama_fa.ps.inc"     /h 8 /t 1
if errorlevel 1 ( goto ERROR )

if "%1" == "" (
  @echo on
  pause
) else (
  @echo on
)

goto EXIT

:ERROR
@echo on
rem エラーが発生しました
pause

:EXIT
