@echo off

if "%PROCESSOR_ARCHITECTURE%" == "x86" (
  set MIX_PLATFORM_TARGET=x86
) else (
  set MIX_PLATFORM_TARGET=x64
)

PATH=..\Vendor\DirectX\Utilities\bin\%MIX_PLATFORM_TARGET%;..\Utilities;%PATH%

set MIX_SRC_SS_MTL_DIR=Source\Scene\Standard\Material
set MIX_SRC_ML_DIR=Source\Graphics\Utility
set MIX_SRC_MQ_DIR=Source\Scene\Common\Misc

set MIX_OBJ_DIR=Objects\Tool
set MIX_MTRL_OBJ_DIR=%MIX_OBJ_DIR%\Standard\Material
set MIX_MISC_OBJ_DIR=%MIX_OBJ_DIR%\Misc

set MIX_DST_DIR=..\Tools\Common\Source\Mix\Tool\Win32\Core\Graphics\Shader
set MIX_MTRL_DST_DIR=%MIX_DST_DIR%\Standard\Material
set MIX_MISC_DST_DIR=%MIX_DST_DIR%\Misc

rem Objects directory

if not exist %MIX_MTRL_OBJ_DIR% ( mkdir "%MIX_MTRL_OBJ_DIR%" )
if not exist %MIX_MISC_OBJ_DIR% ( mkdir "%MIX_MISC_OBJ_DIR%" )

rem Destination directory

if not exist %MIX_MTRL_DST_DIR% ( mkdir "%MIX_MTRL_DST_DIR%" )
if not exist %MIX_MISC_DST_DIR% ( mkdir "%MIX_MISC_DST_DIR%" )

rem Process material

includer /i "%MIX_SRC_SS_MTL_DIR%\default.vs.txt" /o "%MIX_MTRL_OBJ_DIR%\default.vs.txt"
if errorlevel 1 ( goto ERROR )
includer /i "%MIX_SRC_SS_MTL_DIR%\default.ps.txt" /o "%MIX_MTRL_OBJ_DIR%\default.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_MTRL_OBJ_DIR%\default.vs.txt" /o "%MIX_MTRL_DST_DIR%\default.vs.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_MTRL_OBJ_DIR%\default.ps.txt" /o "%MIX_MTRL_DST_DIR%\default.ps.inc" /h 8 /t 1
if errorlevel 1 ( goto ERROR )

rem Process misc

fxc.exe /nologo /E "main"     /T "vs_3_0" /Fo "%MIX_MISC_OBJ_DIR%\line.vs" "%MIX_SRC_ML_DIR%\line.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"     /T "ps_3_0" /Fo "%MIX_MISC_OBJ_DIR%\line.ps" "%MIX_SRC_ML_DIR%\line.ps.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "main"     /T "vs_3_0" /Fo "%MIX_MISC_OBJ_DIR%\quad.vs" "%MIX_SRC_MQ_DIR%\sampling.vs.txt"
if errorlevel 1 ( goto ERROR )
fxc.exe /nologo /E "mainCopy" /T "ps_3_0" /Fo "%MIX_MISC_OBJ_DIR%\quad.ps" "%MIX_SRC_MQ_DIR%\sampling.ps.txt"
if errorlevel 1 ( goto ERROR )

BinToTxt.exe /i "%MIX_MISC_OBJ_DIR%\line.vs" /o "%MIX_MISC_DST_DIR%\line.vs.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_MISC_OBJ_DIR%\line.ps" /o "%MIX_MISC_DST_DIR%\line.ps.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_MISC_OBJ_DIR%\quad.vs" /o "%MIX_MISC_DST_DIR%\quad.vs.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )
BinToTxt.exe /i "%MIX_MISC_OBJ_DIR%\quad.ps" /o "%MIX_MISC_DST_DIR%\quad.ps.inc"  /h 8 /t 1
if errorlevel 1 ( goto ERROR )

if "%1" == "" (
  @echo on
  pause
) else (
  @echo on
)

goto EXIT

:ERROR
@echo on
rem エラーが発生しました
pause

:EXIT
