﻿using System;
using System.Collections.Generic;

namespace Mix.Tool.ArchiveEditor
{
    /// <summary>
    /// ディレクトリノードコレクションインターフェース
    /// </summary>
    public interface IDirectoryNodeCollection : IEnumerable<IDirectoryNode>
    {
        /// <summary>
        /// ディレクトリノードの数を取得
        /// </summary>
        int Count
        {
            get;
        }

        /// <summary>
        /// ディレクトリノードを取得
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <returns>ディレクトリノード</returns>
        IDirectoryNode this[int index]
        {
            get;
        }
    }
}
