﻿using System;
using System.Collections.Generic;

namespace Mix.Tool.ArchiveEditor
{
    /// <summary>
    /// ファイルノードコレクションインターフェース
    /// </summary>
    public interface IFileNodeCollection : IEnumerable<IFileNode>
    {
        /// <summary>
        /// ファイルノードの数を取得
        /// </summary>
        int Count
        {
            get;
        }

        /// <summary>
        /// ファイルノードを取得します
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <returns>ファイルノード</returns>
        IFileNode this[int index]
        {
            get;
        }
    }
}
