﻿using System;
using System.Windows.Forms;

namespace Mix.Tool.ArchiveEditor
{
    public partial class NewProjectForm : Form
    {
        public string RootDirectoryName
        {
            get { return textBoxRootDirectory.Text; }
        }

        public string ArchiveDirectoryName
        {
            get { return textBoxArchiveDirectory.Text; }
        }

        public string ArchiveFileName
        {
            get { return textBoxArchiveFile.Text; }
        }

        public NewProjectForm()
        {
            InitializeComponent();
        }

        private void NewProjectForm_Load(object sender, EventArgs e)
        {
            groupBoxArchive.Enabled = false;
            buttonOK.Enabled = false;
        }

        private void buttonRootDirectory_Click(object sender, EventArgs e)
        {
            using (Mix.Tool.DirectoryBrowseDialog dlg = new DirectoryBrowseDialog())
            {
                dlg.Root = DirectoryBrowseDialog.RootType.Desktop;
                dlg.DirectoryName = textBoxRootDirectory.Text;

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (CheckArchiveDirectoryName(dlg.DirectoryName, textBoxArchiveDirectory.Text) == true)
                    {
                        textBoxRootDirectory.Text = dlg.DirectoryName;
                        groupBoxArchive.Enabled = true;
                    }
                    else
                    {
                        string mes = String.Format(Properties.Resources.Mes_IllegalRootDirectory, dlg.DirectoryName, textBoxArchiveDirectory.Text);
                        if (MessageDialog.Show(mes, Properties.Resources.Title, MessageDialogButtons.YesNo, MessageDialogIcon.Warning, MessageDialogDefaultButton.Button2) == DialogResult.Yes)
                        {
                            textBoxRootDirectory.Text = dlg.DirectoryName;
                            textBoxArchiveDirectory.Text = "";
                        }
                    }
                }
            }
        }

        private void buttonArchiveDirectory_Click(object sender, EventArgs e)
        {
            using (DirectoryBrowseDialog dlg = new DirectoryBrowseDialog())
            {
                dlg.Root = DirectoryBrowseDialog.RootType.Specify;

                dlg.RootDirectoryName = textBoxRootDirectory.Text;
                dlg.DirectoryName = textBoxArchiveDirectory.Text;

                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (CheckArchiveDirectoryName(textBoxRootDirectory.Text, dlg.DirectoryName) == true)
                    {
                        textBoxArchiveDirectory.Text = dlg.DirectoryName;
                    }
                    else
                    {
                        string mes = String.Format(Properties.Resources.Mes_IllegalArchiveDirectory, dlg.DirectoryName, textBoxRootDirectory.Text);
                        MessageDialog.Show(mes, Properties.Resources.Title, MessageDialogButtons.OK, MessageDialogIcon.Warning);
                    }
                }
            }

        }

        private void buttonArchiveFile_Click(object sender, EventArgs e)
        {
            archiveFileDialog.FileName = textBoxArchiveFile.Text;

            if (archiveFileDialog.ShowDialog() == DialogResult.OK)
            {
                textBoxArchiveFile.Text = archiveFileDialog.FileName;
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            Close();
        }

        private void textBoxRootDirectory_TextChanged(object sender, EventArgs e)
        {
            UpdateOK();
        }

        private void textBoxArchiveDirectory_TextChanged(object sender, EventArgs e)
        {
            UpdateOK();
        }

        private void textBoxArchiveFile_TextChanged(object sender, EventArgs e)
        {
            UpdateOK();
        }

        private void UpdateOK()
        {
            if ((textBoxRootDirectory.Text.Length <= 0) ||
                (textBoxArchiveDirectory.Text.Length <= 0) ||
                (textBoxArchiveFile.Text.Length <= 0))
            {
                buttonOK.Enabled = false;
            }
            else
            {
                buttonOK.Enabled = true;
            }
        }

        private bool CheckArchiveDirectoryName(string rootDirectoryName, string archiveDirectoryName)
        {
            if (archiveDirectoryName.Length <= 0)
            {
                return true;
            }

            if (rootDirectoryName.Length > archiveDirectoryName.Length)
            {
                return false;
            }

            if ((rootDirectoryName.Length == archiveDirectoryName.Length) &&
                (rootDirectoryName == archiveDirectoryName))
            {
                return false;
            }

            string temp = archiveDirectoryName.Substring(0, rootDirectoryName.Length);
            if (rootDirectoryName != temp)
            {
                return false;
            }

            return true;
        }
    }
}
