﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace Mix.Tool.ArchiveEditor
{
    public partial class ProjectPropertyForm : Form
    {
        private string rootDirectoryName = "";
        private string archiveDirectoryName = "";
        private string archiveFileName = "";
        private int archiveAlignment = 1;

        public string RootDirectoryName
        {
            set { rootDirectoryName = value; }
        }

        public string ArchiveDirectoryName
        {
            set { archiveDirectoryName = value; }
        }

        public string ArchiveFileName
        {
            get { return archiveFileName; }
            set { archiveFileName = value; }
        }

        public int ArchiveAlignment
        {
            get { return archiveAlignment; }
            set { archiveAlignment = value; }
        }

        public ProjectPropertyForm()
        {
            InitializeComponent();
        }

        private void ProjectPropertyForm_Load(object sender, EventArgs e)
        {
            textBoxRootDirectory.Text = rootDirectoryName;
            textBoxRootDirectory.Select(rootDirectoryName.Length, 0);
            textBoxArchiveDirectory.Text = archiveDirectoryName;
            textBoxArchiveFile.Text = archiveFileName;
            numUDArchiveAlignment.Value = archiveAlignment;

            UpdateAlignmentInfo();
        }

        private void buttonArchiveFile_Click(object sender, EventArgs e)
        {
            if (archiveFileDialog.ShowDialog() == DialogResult.OK)
            {
                textBoxArchiveFile.Text = archiveFileDialog.FileName;
            }
        }

        private void buttonOK_Click(object sender, EventArgs e)
        {
            archiveFileName = textBoxArchiveFile.Text;
            archiveAlignment = (int)numUDArchiveAlignment.Value;

            this.DialogResult = DialogResult.OK;

            Close();
        }

        private void buttonCancel_Click(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            Close();
        }

        private void numUDArchiveAlignment_ValueChanged(object sender, EventArgs e)
        {
            UpdateAlignmentInfo();
        }

        private void UpdateAlignmentInfo()
        {
            Int64 totalfileSize = (4294967295 * (Int64)numUDArchiveAlignment.Value);
            labelArchiveAlignment_Info.Text = String.Format(Properties.Resources.ArchiveAlignment_Info, Utility.FileSizeToString64(totalfileSize));
        }
    }
}
