﻿using System;
using System.Windows.Forms;
using System.Drawing;
using System.ComponentModel;

namespace Mix.Tool
{
    /// <summary>
    /// パーティーションクラス
    /// </summary>
    [ToolboxItem(true)]
    public class Partition : Control
    {
        protected override void OnTextChanged(EventArgs e)
        {
            base.OnTextChanged(e);
            this.Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            float fontSize = this.Font.Height;
            SizeF textSize = e.Graphics.MeasureString(this.Text, this.Font);

            float y = this.Height * 0.5f - 1.0f;

            if (this.Text.Length > 0)
            {
                DrawLine(e.Graphics, y, 0.0f, fontSize - 1.0f);
                DrawLine(e.Graphics, y, fontSize + 1.0f + textSize.Width + 1.0f, this.Width - 1.0f);

                if (this.Enabled == true)
                {
                    e.Graphics.DrawString(this.Text, this.Font, SystemBrushes.ControlText, fontSize + 1.0f, (this.Height - fontSize) * 0.5f - 1.0f);
                }
                else
                {
                    e.Graphics.DrawString(this.Text, this.Font, SystemBrushes.GrayText, fontSize + 1.0f, (this.Height - fontSize) * 0.5f - 1.0f);
                }
            }
            else
            {
                DrawLine(e.Graphics, y, 0.0f, this.Width - 1.0f);
            }

            base.OnPaint(e);
        }

        private static void DrawLine(Graphics g, float y, float x0, float x1)
        {
            g.DrawLine(SystemPens.ControlDark, x0, y, x1, y);
            g.DrawLine(SystemPens.ControlLightLight, x0, y + 1, x1, y + 1);
        }
    }
}
