#include "Archiver.h"
#include "Mix/Tool/Win32/Archiver.h"

using namespace System;
using namespace System::Runtime::InteropServices;

namespace Mix{ namespace Tool{

System::String^ Archiver::RootDirectoryName::get( void )
{
	return static_cast<System::String^>( m_RootDirectoryName->Clone() );
}

void Archiver::RootDirectoryName::set( System::String^ value )
{
	m_RootDirectoryName = static_cast<System::String^>( value->Clone() );
}

System::String^ Archiver::InputDirectoryName::get( void )
{
	return static_cast<System::String^>( m_InputDirectoryName->Clone() );
}

void Archiver::InputDirectoryName::set( System::String^ value )
{
	m_InputDirectoryName = static_cast<System::String^>( value->Clone() );
}

System::String^ Archiver::OutputFileName::get( void )
{
	return static_cast<System::String^>( m_OutputFileName->Clone() );
}

void Archiver::OutputFileName::set( System::String^ value )
{
	m_OutputFileName = static_cast<System::String^>( value->Clone() );
}

unsigned int Archiver::Alignment::get( void )
{
	return m_Alignment;
}

void Archiver::Alignment::set( unsigned int value )
{
	m_Alignment = value;
}

unsigned int Archiver::TemporaryBufferSize::get( void )
{
	return m_TemporaryBufferSize;
}

void Archiver::TemporaryBufferSize::set( unsigned int value )
{
	m_TemporaryBufferSize = value;
}

void Archiver::PreCreate::set( DelegatePreCreate^ value )
{
	preCreate = value;
}

void Archiver::ProcessFile::set( DelegateProcessFile^ value )
{
	processFile = value;
}

void Archiver::UpdateFileProgress::set( DelegateUpdateFileProgress^ value )
{
	updateFileProgress = value;
}

void Archiver::UpdateTotalProgress::set( DelegateUpdateTotalProgress^ value )
{
	updateTotalProgress = value;
}

void Archiver::End::set( DelegateEnd^ value )
{
	end = value;
}

Archiver::Archiver( void ) :
m_RootDirectoryName( L"" ),
m_InputDirectoryName( L"" ),
m_OutputFileName( L"" ),
m_Alignment( 1 ),
m_TemporaryBufferSize( 0 ),
preCreate( nullptr ),
processFile( nullptr ),
updateFileProgress( nullptr ),
updateTotalProgress( nullptr ),
end( nullptr )
{
}

void Archiver::Run( void )
{
	::MAF_RESULT result;
	::MAF_CONTEXT context;
	::MAF_CONTEXT_WRITE contextWrite;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	IntPtr rootDirNamePtr = Marshal::StringToHGlobalUni( m_RootDirectoryName );
	IntPtr inputDirNamePtr = Marshal::StringToHGlobalUni( m_InputDirectoryName );
	IntPtr outputFileNamePtr = Marshal::StringToHGlobalUni( m_OutputFileName );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// A[JCus
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Logger::Clear();
	Logger::Print( Logger::Type::Info, L"i[t@C̏WĂ܂" );

	result = ::MAF_InitializeContext(
		static_cast<const wchar_t*>( rootDirNamePtr.ToPointer() ),
		static_cast<const wchar_t*>( inputDirNamePtr.ToPointer() ),
		static_cast<const wchar_t*>( outputFileNamePtr.ToPointer() ),
		m_Alignment,
		m_TemporaryBufferSize,
		context,
		contextWrite );

	if( result == MAF_OK )
	{
		if( preCreate != nullptr )
		{
			preCreate( context.fileList.size(), context.totalFileSize, context.totalSize );
		}

		Logger::Print( Logger::Type::Info, L"t@C̊i[Jn܂" );

		result = ::MAF_BeginWrite( context, contextWrite );

		if( result == MAF_OK )
		{
			do
			{
				unsigned int eventFlags = ::MAF_TakeEvent( contextWrite );

				if( ( eventFlags & MAF_EVENT_OUTPUTPROGRESS ) == MAF_EVENT_OUTPUTPROGRESS )
				{
					if( updateTotalProgress != nullptr )
					{
						updateTotalProgress( static_cast<int>( contextWrite.outputProgress ) );
					}
				}
				if( ( eventFlags & MAF_EVENT_FILEINDEX ) == MAF_EVENT_FILEINDEX )
				{
					if( processFile != nullptr )
					{
						processFile( gcnew System::String( ::MAF_GetFileName( context, contextWrite ) ), context.fileList[contextWrite.fileIndex].dataSize );
					}
				}
				if( ( eventFlags & MAF_EVENT_FILEPROGRESS ) == MAF_EVENT_FILEPROGRESS )
				{
					if( updateFileProgress != nullptr )
					{
						updateFileProgress( static_cast<int>( contextWrite.fileProgress ) );
					}
				}

				result = ::MAF_ProcWrite( context, contextWrite );

				::Sleep( 0 );
			}
			while( result == MAF_CONTINUE );

			if( result == MAF_OK )
			{
				result = ::MAF_EndWrite( context, contextWrite );
				if( result != MAF_OK )
				{
					System::String^ fileName = gcnew System::String( ::MAF_GetFileName( context, contextWrite ) );

					switch( result )
					{
					case MAF_ERROR_IO_WRITEOUTPUTFILE:
						Logger::Print( Logger::Type::Error, System::String::Format( L"t@C̊i[Ɏs܂ : o͐̃t@CgpAeʂsĂ܂" ) );
						break;
					default:
						Logger::Print( Logger::Type::Error, System::String::Format( L"t@C̊i[ɒvIȃG[܂" ) );
						break;
					}
				}
			}
			else
			{
				System::String^ fileName = gcnew System::String( ::MAF_GetFileName( context, contextWrite ) );

				switch( result )
				{
				case MAF_ERROR_IO_WRITEOUTPUTFILE:
					Logger::Print( Logger::Type::Error, System::String::Format( L"t@C \'{0}\' ̊i[Ɏs܂ : o͐̃t@CgpAeʂsĂ܂", fileName ) );
					break;
				case MAF_ERROR_IO_READSOURCEFILE:
					Logger::Print( Logger::Type::Error, System::String::Format( L"t@C \'{0}\' ̓ǂݍ݂Ɏs܂ : t@CgpA܂݂͑Ă܂", fileName ) );
					break;
				default:
					Logger::Print( Logger::Type::Error, System::String::Format( L"t@C \'{0}\' ̊i[ɒvIȃG[܂", fileName ) );
					break;
				}
			}
		}
		else
		{
			switch( result )
			{
			case MAF_ERROR_IO_WRITEOUTPUTFILE:
				Logger::Print( Logger::Type::Error, System::String::Format( L"t@C̊i[Ɏs܂ : o͐̃t@CgpAeʂsĂ܂" ) );
				break;
			default:
				Logger::Print( Logger::Type::Error, System::String::Format( L"t@C̊i[ɒvIȃG[܂" ) );
				break;
			}
		}
	}
	else
	{
		//t@C̎WɎs
		switch( result )
		{
		case MAF_ERROR_INVALID_ARGUMENT:
			Logger::Print( Logger::Type::Error, System::String::Format( L"i[t@C̏̎WɎs܂ : p[^sł" ) );
			break;
		case MAF_ERROR_ILLEGAL_DIRECTORYNAME:
			Logger::Print( Logger::Type::Error, System::String::Format( L"i[t@C̏̎WɎs܂ : ̓fBNg \'{1}\' ́A[gfBNg \'{0}\' ɑ݂ĂKv܂", m_InputDirectoryName, m_RootDirectoryName ) );
			break;
		case MAF_ERROR_IO_COLLECTFILE:
			Logger::Print( Logger::Type::Error, System::String::Format( L"i[t@C̏̎WɎs܂ : i[t@Cgpł\܂" ) );
			break;
		case MAF_ERROR_IO_COLLECTFILE_BIGFILE:
			Logger::Print( Logger::Type::Error, System::String::Format( L"i[t@C̏̎WɎs܂ : i[t@C̃TCY 4GB ȓɂĂ" ) );
			break;
		case MAF_ERROR_IO_CREATEOUTPUTFILE:
			Logger::Print( Logger::Type::Error, System::String::Format( L"t@C̊i[̊JnɎs܂ : t@C \'{0}\' 쐬ł܂ł", m_OutputFileName ) );
			break;
		default:
			break;
		}
	}

	::MAF_ReleaseContext( context, contextWrite );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Marshal::FreeHGlobal( outputFileNamePtr );
	Marshal::FreeHGlobal( inputDirNamePtr );
	Marshal::FreeHGlobal( rootDirNamePtr );

	if( result == MAF_OK )
	{
		Logger::Print( Logger::Type::Info, System::String::Format( L"ɏI܂" ) );
	}

	if( end != nullptr )
	{
		end();
	}
}

}}
