#pragma once

#include "Mix/Tool/CLR/Core/Utility/DefinitionOrderTypeConverter.h"
#include "Mix/Tool/CLR/Core/Dynamics/Joint.h"

using namespace System::ComponentModel;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{
	class BallJoint;
}}}}

namespace Mix{ namespace Tool{ namespace Dynamics{

	[TypeConverter(Mix::Tool::Utility::DefinitionOrderTypeConverter::typeid)]
	public ref class BallJoint : public Mix::Tool::Dynamics::Joint
	{
	private:
		Mix::Tool::Win32::Dynamics::BallJoint* impl;

	public:
		BallJoint( void );
		BallJoint(	Mix::Tool::Math::Vector^ swingAxis,
					Mix::Tool::Math::Vector^ twistAxis,
					float swingLimit1,
					float swingLimit2,
					float twistLimit,
					bool collisionDisabled,
					float spring,
					float damper,
					float limitSpring,
					float limitDamper );

		virtual ~BallJoint( void );

		[Category("\t\t{")]
		[Description( L"XEBO̎w肵܂B" )]
		[TypeConverter(Mix::Tool::Math::VectorConverter::typeid)]
		property Mix::Tool::Math::Vector^ SwingAxis
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		[Category("\t\t{")]
		[Description( L"XEBO̍őpxPw肵܂B" )]
		property float SwingLimit1
		{
			float get( void );
			void set( float value );
		}

		[Category("\t\t{")]
		[Description( L"XEBO̍őpxQw肵܂B" )]
		property float SwingLimit2
		{
			float get( void );
			void set( float value );
		}

		[Category("\t\t{")]
		[Description( L"cCXg̎w肵܂B" )]
		[TypeConverter(Mix::Tool::Math::VectorConverter::typeid)]
		property Mix::Tool::Math::Vector^ TwistAxis
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		[Category("\t\t{")]
		[Description( L"cCXg̍őpxw肵܂B" )]
		property float TwistLimit
		{
			float get( void );
			void set( float value );
		}

		[Category("\tTXyV")]
		[Description( L"ol̂炩w肵܂B" )]
		property float Spring
		{
			float get( void );
			void set( float value );
		}

		[Category("\tTXyV")]
		[Description("_p[̌͂w肵܂B")]
		property float Damper
		{
			float get( void );
			void set( float value );
		}

		[Category("\tTXyV")]
		[Description( L"~bg( XBOAcCXg̍ŏAőpx )ɉeol̂炩w肵܂B" )]
		property float LimitSpring
		{
			float get( void );
			void set( float value );
		}

		[Category("\tTXyV")]
		[Description("~bg( XBOAcCXg̍ŏAőpx )ɉe_p[̌͂w肵܂B")]
		property float LimitDamper
		{
			float get( void );
			void set( float value );
		}

	public:
		[Browsable(false)]
		property bool CollisionDisabled
		{
			virtual bool get( void ) override;
			virtual void set( bool value ) override;
		}

	internal:
		property Mix::Tool::Win32::Dynamics::Joint* Impl
		{
			virtual Mix::Tool::Win32::Dynamics::Joint* get( void ) override;
		}
	};

}}}
