#include "Mix/Tool/CLR/Core/Dynamics/BoxShape.h"

#include "Mix/Tool/Win32/Core/Dynamics/Factory.h"
#include "Mix/Tool/Win32/Core/Dynamics/BoxShape.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

BoxShape::BoxShape( Mix::Tool::Win32::Dynamics::BoxShape* _impl ) :
impl( _impl ),
m_bInternalImpl( false )
{
}

BoxShape::BoxShape( const D3DXVECTOR3& halfExtens ) :
impl( NULL ),
m_bInternalImpl( true )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreateBoxShape( halfExtens );
}

BoxShape::BoxShape( Mix::Tool::Math::Vector^ halfExtens ) :
impl( NULL ),
m_bInternalImpl( true )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreateBoxShape( D3DXVECTOR3( halfExtens->X, halfExtens->Y, halfExtens->Z ) );
}

BoxShape::~BoxShape( void )
{
	if( m_bInternalImpl == true )
	{
		if( impl != NULL )
		{
			delete impl;
			impl = NULL;
		}
	}
	else
	{
		impl = NULL;
	}
}

Mix::Tool::Math::Vector^ BoxShape::HalfExtents::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	D3DXVECTOR3 he = impl->GetHalfExtents();

	return gcnew Mix::Tool::Math::Vector( he.x, he.y, he.z, 1.0f );
}

Mix::Tool::Win32::Dynamics::Shape* BoxShape::Impl::get( void )
{
	return impl;
}

}}}
