#include "Mix/Tool/CLR/Core/Dynamics/CapsuleShape.h"

#include "Mix/Tool/Win32/Core/Dynamics/Factory.h"
#include "Mix/Tool/Win32/Core/Dynamics/CapsuleShape.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

CapsuleShape::CapsuleShape( Mix::Tool::Win32::Dynamics::CapsuleShape* _impl ) :
impl( _impl ),
m_bInternalImpl( false )
{
}

CapsuleShape::CapsuleShape( const D3DXVECTOR3& halfExtents ) :
impl( NULL ),
m_bInternalImpl( true )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreateCapsuleShape( halfExtents );

	switch( impl->GetAxis() )
	{
	case Mix::Tool::Win32::Dynamics::aX:
		m_Axis = Mix::Tool::Dynamics::Axis::X;
		break;
	case Mix::Tool::Win32::Dynamics::aY:
		m_Axis = Mix::Tool::Dynamics::Axis::Y;
		break;
	case Mix::Tool::Win32::Dynamics::aZ:
		m_Axis = Mix::Tool::Dynamics::Axis::Z;
		break;
	}
}

CapsuleShape::CapsuleShape( Mix::Tool::Dynamics::Axis axis, float radius, float length ) :
impl( NULL ),
m_bInternalImpl( true )
{
	Mix::Tool::Win32::Dynamics::AXIS w32Axis;

	switch( axis )
	{
	case Mix::Tool::Dynamics::Axis::X:
		w32Axis = Mix::Tool::Win32::Dynamics::aX;
		break;
	case Mix::Tool::Dynamics::Axis::Y:
		w32Axis = Mix::Tool::Win32::Dynamics::aY;
		break;
	case Mix::Tool::Dynamics::Axis::Z:
		w32Axis = Mix::Tool::Win32::Dynamics::aZ;
		break;
	}

	m_Axis = axis;

	impl = Mix::Tool::Win32::Dynamics::Factory::CreateCapsuleShape( w32Axis, radius, length );
}

CapsuleShape::~CapsuleShape( void )
{
	if( m_bInternalImpl == true )
	{
		if( impl != NULL )
		{
			delete impl;
			impl = NULL;
		}
	}
	else
	{
		impl = NULL;
	}
}

Mix::Tool::Dynamics::Axis CapsuleShape::Axis::get( void )
{
	return m_Axis;
}

float CapsuleShape::Radius::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->GetRadius();
}

float CapsuleShape::Length::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->GetLength();
}

Mix::Tool::Win32::Dynamics::Shape* CapsuleShape::Impl::get( void )
{
	return impl;
}

}}}
