#include "Mix/Tool/CLR/Core/Dynamics/CollisionObject.h"

#include "Mix/Tool/Win32/Core/Dynamics/CollisionObject.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

Mix::Tool::Dynamics::Groups CollisionObject::Group::get( void )
{
	if( Impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return static_cast<Mix::Tool::Dynamics::Groups>( Impl->GetGroup() );
}

void CollisionObject::Group::set( Mix::Tool::Dynamics::Groups value )
{
	if( Impl != NULL )
	{
		Impl->SetGroup( static_cast<short>( value ) );
	}
	else
	{
		throw gcnew System::InvalidOperationException();
	}
}

Mix::Tool::Dynamics::Groups CollisionObject::GroupMask::get( void )
{
	if( Impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return static_cast<Mix::Tool::Dynamics::Groups>( Impl->GetGroupMask() );
}

void CollisionObject::GroupMask::set( Mix::Tool::Dynamics::Groups value )
{
	if( Impl != NULL )
	{
		Impl->SetGroupMask( static_cast<short>( value ) );
	}
	else
	{
		throw gcnew System::InvalidOperationException();
	}
}

Mix::Tool::Math::Vector^ CollisionObject::Position::get( void )
{
	if( Impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	D3DXVECTOR3 pos = Impl->GetWorldPosition();

	return gcnew Mix::Tool::Math::Vector( pos.x, pos.y, pos.z, 1.0f );
}

void CollisionObject::Position::set( Mix::Tool::Math::Vector^ value )
{
	if( Impl != NULL )
	{
		Impl->SetWorldPosition( D3DXVECTOR3( value->X, value->Y, value->Z ) );
	}
	else
	{
		throw gcnew System::InvalidOperationException();
	}
}

Mix::Tool::Math::Quaternion^ CollisionObject::Rotation::get( void )
{
	if( Impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	D3DXQUATERNION rot = Impl->GetWorldRotation();

	return gcnew Mix::Tool::Math::Quaternion( rot.x, rot.y, rot.z, rot.w );
}

void CollisionObject::Rotation::set( Mix::Tool::Math::Quaternion^ value )
{
	if( Impl != NULL )
	{
		Impl->SetWorldRotation( D3DXQUATERNION( value->X, value->Y, value->Z, value->W ) );
	}
	else
	{
		throw gcnew System::InvalidOperationException();
	}
}

}}}
