#include "Mix/Tool/CLR/Core/Dynamics/Design/Part.h"

#include "Mix/Tool/Win32/Core/Dynamics/Design/Part.h"
#include "Mix/Tool/CLR/Core/Dynamics/Joint.h"

namespace Mix{ namespace Tool{ namespace Dynamics{ namespace Design{

Part::Part( Mix::Tool::Win32::Dynamics::Design::Part* _implPart ) : Basic( _implPart ),
implPart( _implPart ),
m_Joint( nullptr )
{
}

Part::~Part( void )
{
	if( implPart != NULL )
	{
		implPart->Joint_Set( NULL );
		implPart = NULL;
	}

	m_Joint = nullptr;
}

Mix::Tool::Dynamics::Joint^ Part::Joint::get( void )
{
	return m_Joint;
}

void Part::Joint::set( Mix::Tool::Dynamics::Joint^ value )
{
	if( implPart == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	if( m_Joint != value )
	{
		if( value != nullptr )
		{
			if( value->Impl == NULL )
			{
				throw gcnew System::Exception( L"ݒ肵悤ƂWCg͊ɔjĂ܂" );
			}

			if( implPart->Joint_Set( value->Impl ) == false )
			{
				throw gcnew System::Exception( L"Joint_Set( value->Impl ) G[Ԃ܂" );
			}
		}
		else
		{
			if( implPart->Joint_Set( NULL ) == false )
			{
				throw gcnew System::Exception( L"Joint_Set( NULL ) G[Ԃ܂" );
			}
		}

		if( m_Joint != nullptr )
		{
			delete m_Joint;
			m_Joint = nullptr;
		}

		m_Joint = value;
	}
}

Mix::Tool::Math::Vector^ Part::JointPivot::get( void )
{
	if( implPart == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	const D3DXVECTOR3& pivot = implPart->Joint_GetLocalPivotA();

	return gcnew Mix::Tool::Math::Vector( pivot.x, pivot.y, pivot.z, 1.0f );
}

void Part::JointPivot::set( Mix::Tool::Math::Vector^ value )
{
	if( implPart == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	implPart->Joint_SetLocalPivotA( D3DXVECTOR3( value->X, value->Y, value->Z ) );
}

}}}}
