#pragma once

//#include "Mix/Tool/CLR/Core/Dynamics/Design/ISimulator.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{ namespace Design{
	class Terrain;
}}}}}

namespace Mix{ namespace Tool{ namespace Dynamics{
	ref class PhysicsMaterial;
	ref class World;
}}}

namespace Mix{ namespace Tool{ namespace Dynamics{ namespace Design{

	public enum class TerrainStatus
	{
		Destroyed,	//jĂ
		Importing,	//C|[g
		Available,	//p\
	};

	public ref class TerrainPart
	{
	private:
		Mix::Tool::Win32::Dynamics::Design::Terrain* implTerrain;

		int m_Index;
		System::String^ m_Name;
		Mix::Tool::Math::Vector^ m_Color;
		System::Drawing::Image^ m_Image;
		Mix::Tool::Dynamics::PhysicsMaterial^ m_PhysicsMaterial;

	internal:
		TerrainPart(	Mix::Tool::Win32::Dynamics::Design::Terrain* implTerrain,
						int _index,
						const wchar_t* pName,
						const D3DXVECTOR4& color,
						const wchar_t* pImageFilePath );

		~TerrainPart( void );

	public:
		event System::EventHandler^ PhysicsMaterialDiscarded;

		property System::String^ Name
		{
			System::String^ get( void );
		}

		property Mix::Tool::Math::Vector^ Color
		{
			Mix::Tool::Math::Vector^ get( void );
		}

		property System::Drawing::Image^ Image
		{
			System::Drawing::Image^ get( void );
		}

		property Mix::Tool::Dynamics::PhysicsMaterial^ PhysicsMaterial
		{
			Mix::Tool::Dynamics::PhysicsMaterial^ get( void );
			void set( Mix::Tool::Dynamics::PhysicsMaterial^ value );
		}

	private:
		void RemovePhysicsMaterialEvents( void );
		void PhysicsMaterial_ValueChanged( System::Object^ sender, System::EventArgs^ e );
		void PhysicsMaterial_Disposing( System::Object^ sender, System::EventArgs^ e );
	};

	public ref class TerrainPartCollection : public System::Collections::IEnumerable
	{
	private:
		System::Collections::Generic::List<Mix::Tool::Dynamics::Design::TerrainPart^>^ m_List;

	internal:
		TerrainPartCollection( void );
		~TerrainPartCollection( void );

		void Add(	Mix::Tool::Win32::Dynamics::Design::Terrain* implTerrain,
					int index,
					const wchar_t* pName,
					const D3DXVECTOR4& color,
					const wchar_t* pImageFilePath );

	public:
		property int Count
		{
			int get( void );
		}

		property Mix::Tool::Dynamics::Design::TerrainPart^ default[int]
		{
			Mix::Tool::Dynamics::Design::TerrainPart^ get( int index );
		}

		property System::Collections::IList^ DataSource
		{
			System::Collections::IList^ get( void );
		}

		int IndexOfName( System::String^ name );

	public:
		virtual System::Collections::IEnumerator^ GetEnumerator( void );
	};

	public ref class Terrain
	{
	private:
		Mix::Tool::Win32::Dynamics::Design::Terrain* implTerrain;

		System::Object^ m_StatusLock;
		Mix::Tool::Dynamics::Design::TerrainStatus m_Status;

		System::String^ m_FilePath;
		Mix::Tool::Dynamics::Design::TerrainPartCollection^ m_Parts;

	internal:
		Terrain( Mix::Tool::Win32::Dynamics::Design::Terrain* _implTerrain );
		~Terrain( void );

	public:
		property Mix::Tool::Dynamics::Design::TerrainStatus Status
		{
		public:
			Mix::Tool::Dynamics::Design::TerrainStatus get( void );
		private:
			void set( Mix::Tool::Dynamics::Design::TerrainStatus value );
		}

		property System::String^ FilePath
		{
			System::String^ get( void );
		}

		property Mix::Tool::Dynamics::Design::TerrainPartCollection^ Parts
		{
			Mix::Tool::Dynamics::Design::TerrainPartCollection^ get( void );
		}

		void Initialize( void );

		void Import( System::String^ filePath, int serializeCapacity );
		void ImportFinalize( void );

		void Destroy( void );
	};

}}}}
