#pragma once

#include "Mix/Tool/CLR/Core/Utility/BindingItem.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

	public ref class FlagsGenerator : public System::Collections::Generic::IEnumerable<System::String^>
	{
	public:
		ref class ErrorList : public System::Collections::Generic::IEnumerable<System::String^>
		{
		private:
			System::Collections::Generic::List<System::String^>^ m_NameList;
			System::Collections::Generic::List<System::String^>^ m_List;

		internal:
			ErrorList( System::Collections::Generic::List<System::String^>^ nameList );

			void Reset( void );
			void Add( System::String^ name );

		public:
			property int Count
			{
				int get( void );
			}

			property System::String^ default[int]
			{
				System::String^ get( int index );
			}

			bool Remove( System::String^ name );
			void Clear( void );

		public:
			virtual System::Collections::IEnumerator^ GetEnumerator( void );
			virtual System::Collections::Generic::IEnumerator<System::String^>^ GetEnumerator_Generic( void ) = System::Collections::Generic::IEnumerable<System::String^>::GetEnumerator;
		};

	private:
		Mix::Tool::Utility::BindingItemCollection<int>^ m_Owner;
		System::Collections::Generic::List<System::String^>^ m_NameList;
		FlagsGenerator::ErrorList^ m_ErrorList;
		int m_Value;

	internal:
		FlagsGenerator( Mix::Tool::Utility::BindingItemCollection<int>^ owner );
		~FlagsGenerator( void );

	public:
		System::EventHandler^ ValueChanged;

		property int Count
		{
			int get( void );
		}

		property System::String^ default[int]
		{
			System::String^ get( int index );
		}

		property int Value
		{
			int get( void );
		}

		void Clear( void );
		void Add( System::String^ name );
		bool Remove( System::String^ name );
		bool Contains( System::String^ name );

	private:
		void Update( void );
		void ListChanged( System::Object^ sender, System::ComponentModel::ListChangedEventArgs^ e );

	public:
		virtual System::Collections::IEnumerator^ GetEnumerator( void );
		virtual System::Collections::Generic::IEnumerator<System::String^>^ GetEnumerator_Generic( void ) = System::Collections::Generic::IEnumerable<System::String^>::GetEnumerator;
	};

}}}
