#include "Mix/Tool/CLR/Core/Dynamics/PointJoint.h"

#include "Mix/Tool/Win32/Core/Dynamics/Factory.h"
#include "Mix/Tool/Win32/Core/Dynamics/PointJoint.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

PointJoint::PointJoint( void ) :
impl( NULL )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreatePointJoint();
}

PointJoint::PointJoint( bool collisionDisabled, float spring, float damper ) :
impl( NULL )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreatePointJoint( collisionDisabled, spring, damper );
}

PointJoint::~PointJoint( void )
{
	if( impl != NULL )
	{
		delete impl;
		impl = NULL;
	}
}

float PointJoint::Spring::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->GetSpring();
}

void PointJoint::Spring::set( float value )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	impl->SetSpring( value );
}

float PointJoint::Damper::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->GetDamper();
}

void PointJoint::Damper::set( float value )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	impl->SetDamper( value );
}

bool PointJoint::CollisionDisabled::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->GetCollisionDisabled();
}

void PointJoint::CollisionDisabled::set( bool value )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->SetCollisionDisabled( value );
}

Mix::Tool::Win32::Dynamics::Joint* PointJoint::Impl::get( void )
{
	return impl;
}

}}}
