#pragma once

#include "Mix/Tool/CLR/Core/Utility/DefinitionOrderTypeConverter.h"
#include "Mix/Tool/CLR/Core/Dynamics/Joint.h"

using namespace System::ComponentModel;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{
	class PointJoint;
}}}}

namespace Mix{ namespace Tool{ namespace Dynamics{

	[TypeConverter(Mix::Tool::Utility::DefinitionOrderTypeConverter::typeid)]
	public ref class PointJoint : public Mix::Tool::Dynamics::Joint
	{
	private:
		Mix::Tool::Win32::Dynamics::PointJoint* impl;

	public:
		PointJoint( void );
		PointJoint( bool collisionDisabled, float spring, float damper );
		virtual ~PointJoint( void );

		[Category("TXyV")]
		[Description( L"ol̂炩w肵܂B" )]
		property float Spring
		{
			float get( void );
			void set( float value );
		}

		[Category("TXyV")]
		[Description( L"_p[̌͂w肵܂B" )]
		property float Damper
		{
			float get( void );
			void set( float value );
		}

	public:
		[Browsable(false)]
		property bool CollisionDisabled
		{
			virtual bool get( void ) override;
			virtual void set( bool value ) override;
		}

	internal:
		property Mix::Tool::Win32::Dynamics::Joint* Impl
		{
			virtual Mix::Tool::Win32::Dynamics::Joint* get( void ) override;
		}
	};

}}}
