#include "Mix/Tool/CLR/Core/Dynamics/SphereShape.h"

#include "Mix/Tool/Win32/Core/Dynamics/Factory.h"
#include "Mix/Tool/Win32/Core/Dynamics/SphereShape.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

SphereShape::SphereShape( Mix::Tool::Win32::Dynamics::SphereShape* _impl ) :
impl( _impl ),
m_bInternalImpl( false )
{
}

SphereShape::SphereShape( const D3DXVECTOR3& halfExtents ) :
impl( NULL ),
m_bInternalImpl( true )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreateSphereShape( halfExtents );
}

SphereShape::SphereShape( float radius ) :
impl( NULL ),
m_bInternalImpl( true )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreateSphereShape( radius );
}

SphereShape::~SphereShape( void )
{
	if( m_bInternalImpl == true )
	{
		if( impl != NULL )
		{
			delete impl;
			impl = NULL;
		}
	}
	else
	{
		impl = NULL;
	}
}

float SphereShape::Radius::get( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	return impl->GetRadius();
}

Mix::Tool::Win32::Dynamics::Shape* SphereShape::Impl::get( void )
{
	return impl;
}

}}}
