#include "Mix/Tool/CLR/Core/Dynamics/StaticPlane.h"

#include "Mix/Tool/Win32/Core/Dynamics/Factory.h"
#include "Mix/Tool/Win32/Core/Dynamics/StaticPlane.h"
#include "Mix/Tool/CLR/Core/Dynamics/FlagsGenerator.h"
#include "Mix/Tool/CLR/Core/Dynamics/IdentifierGenerator.h"
#include "Mix/Tool/CLR/Core/Dynamics/PhysicsMaterial.h"

namespace Mix{ namespace Tool{ namespace Dynamics{

StaticPlane::StaticPlane( Mix::Tool::Win32::Dynamics::StaticPlane* _impl ) :
impl( _impl ),
m_bInternalImpl( false ),
m_PhysicsMaterial( nullptr )
{
}

StaticPlane::StaticPlane( void ) :
impl( NULL ),
m_bInternalImpl( true ),
m_PhysicsMaterial( nullptr )
{
	impl = Mix::Tool::Win32::Dynamics::Factory::CreateStaticPlane();
}

StaticPlane::~StaticPlane( void )
{
	if( m_bInternalImpl == true )
	{
		if( impl != NULL )
		{
			delete impl;
			impl = NULL;
		}
	}
	else
	{
		impl = NULL;
	}

	m_PhysicsMaterial = nullptr;
}

Mix::Tool::Dynamics::PhysicsMaterial^ StaticPlane::PhysicsMaterial::get( void )
{
	return m_PhysicsMaterial;
}

void StaticPlane::PhysicsMaterial::set( Mix::Tool::Dynamics::PhysicsMaterial^ value )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException();
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// O̕}eÃCxgnh[
	////////////////////////////////////////////////////////////////////////////////////////////////////

	if( m_PhysicsMaterial != nullptr )
	{
		m_PhysicsMaterial->ValueChanged -= gcnew System::EventHandler( this, &StaticPlane::PhysicsMaterial_ValueChanged );
	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// }eA̒lݒ
	////////////////////////////////////////////////////////////////////////////////////////////////////

	Mix::Tool::Win32::Dynamics::MATERIAL w32Material;

	if( value != nullptr )
	{
		w32Material.id = value->Identifier->Value;
		w32Material.attr = value->Attributes->Value;
		w32Material.friction = value->Friction;
		w32Material.restitution = value->Restitution;
	}
	else
	{
		w32Material.id = Mix::Tool::Dynamics::PhysicsMaterial::DefaultIdentifier;
		w32Material.attr = Mix::Tool::Dynamics::PhysicsMaterial::DefaultAttributes;
		w32Material.friction = Mix::Tool::Dynamics::PhysicsMaterial::DefaultFriction;
		w32Material.restitution = Mix::Tool::Dynamics::PhysicsMaterial::DefaultRestitution;
	}

	impl->SetMaterial( w32Material );

	////////////////////////////////////////////////////////////////////////////////////////////////////
	// VK̕}eÃCxgnh[o^
	////////////////////////////////////////////////////////////////////////////////////////////////////

	m_PhysicsMaterial = value;

	if( m_PhysicsMaterial != nullptr )
	{
		m_PhysicsMaterial->ValueChanged += gcnew System::EventHandler( this, &StaticPlane::PhysicsMaterial_ValueChanged );
	}
}

void StaticPlane::PhysicsMaterial_ValueChanged( System::Object^ sender, System::EventArgs^ e )
{
	if( impl != NULL )
	{
		Mix::Tool::Dynamics::PhysicsMaterial^ physicsMaterial = safe_cast<Mix::Tool::Dynamics::PhysicsMaterial^>( sender );
		Mix::Tool::Win32::Dynamics::MATERIAL w32Material;

		w32Material.id = physicsMaterial->Identifier->Value;
		w32Material.attr = physicsMaterial->Attributes->Value;
		w32Material.friction = physicsMaterial->Friction;
		w32Material.restitution = physicsMaterial->Restitution;

		impl->SetMaterial( w32Material );
	}
}

Mix::Tool::Win32::Dynamics::CollisionObject* StaticPlane::Impl::get( void )
{
	return impl;
}

}}}
