#pragma once

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{
	class World;
}}}}

namespace Mix{ namespace Tool{ namespace Dynamics{

	ref class CollisionObject;

	public ref class Picker
	{
	private:
		Mix::Tool::Win32::Dynamics::World* impl;

	internal:
		Picker( Mix::Tool::Win32::Dynamics::World* _impl );
		~Picker( void );

	public:
		void Catch( Mix::Tool::Math::Vector^ eyePos, Mix::Tool::Math::Vector^ fromWorldPos, Mix::Tool::Math::Vector^ toWorldPos );
		void Update( Mix::Tool::Math::Vector^ eyePos, Mix::Tool::Math::Vector^ toWorldPos );
		void Release( void );
	};

	public ref class CollisionObjectCollection : public System::Collections::IEnumerable
	{
	private:
		Mix::Tool::Win32::Dynamics::World* impl;

	private:
		System::Collections::Generic::List<Mix::Tool::Dynamics::CollisionObject^>^ m_List;

	internal:
		CollisionObjectCollection( Mix::Tool::Win32::Dynamics::World* _impl );
		~CollisionObjectCollection( void );

	public:
		property int Count
		{
			int get( void );
		}

		property Mix::Tool::Dynamics::CollisionObject^ default[int]
		{
			Mix::Tool::Dynamics::CollisionObject^ get( int index );
		}

		bool Add( Mix::Tool::Dynamics::CollisionObject^ collObj );
		bool Remove( Mix::Tool::Dynamics::CollisionObject^ collObj );

	public:
		virtual System::Collections::IEnumerator^ GetEnumerator( void );
	};

	public ref class World
	{
	private:
		Mix::Tool::Win32::Dynamics::World* impl;

	private:
		Mix::Tool::Dynamics::CollisionObjectCollection^ m_CollObjCollection;
		Mix::Tool::Dynamics::Picker^ m_Picker;

	internal:
		World( void );
		~World( void );

		void Update( float dt );

		property Mix::Tool::Win32::Dynamics::World* Impl
		{
			Mix::Tool::Win32::Dynamics::World* get( void );
		}

	public:
		property Mix::Tool::Math::Vector^ Gravity
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Dynamics::CollisionObjectCollection^ CollisionObjects
		{
			Mix::Tool::Dynamics::CollisionObjectCollection^ get( void );
		}

		property Mix::Tool::Dynamics::Picker^ Picker
		{
			Mix::Tool::Dynamics::Picker^ get( void );
		}
	};

}}}
