#pragma once

#include "Mix/Tool/CLR/Core/Dynamics/World.h"
#include "Mix/Tool/CLR/Core/Graphics/Manager.h"

using namespace System;

namespace Mix{ namespace Tool{

	public ref class Engine
	{
	private:
		int m_BaseFps;
		unsigned int m_FrameCount;
		unsigned int m_NoDelayCount;
		float m_Fps;
		float m_Dt;
		float m_Mag;
		LARGE_INTEGER* m_Freq;
		LARGE_INTEGER* m_Period;
		LARGE_INTEGER* m_BeforeTime;
		LARGE_INTEGER* m_AfterTime;
		LARGE_INTEGER* m_TimeDiff;
		LARGE_INTEGER* m_SleepTime;
		LARGE_INTEGER* m_OverSleepTime;
		LARGE_INTEGER* m_PrevCalcTime;
		LARGE_INTEGER* m_TempTime;

		Mix::Tool::Dynamics::World^ m_DynamicsWorld;
		Mix::Tool::Graphics::Manager^ m_GraphicsManager;

	public:
		Engine( int baseFps );
		~Engine( void );

		void Update( void );

		property int BaseFps
		{
			int get( void );
		}

		property float Fps
		{
			float get( void );
		}

		property float Dt
		{
			float get( void );
		}

		property float Mag
		{
			float get( void );
		}

		property Mix::Tool::Dynamics::World^ DynamicsWorld
		{
			Mix::Tool::Dynamics::World^ get( void );
		}

		property Mix::Tool::Graphics::Manager^ GraphicsManager
		{
			Mix::Tool::Graphics::Manager^ get( void );
		}
	};
}}
