#pragma once

using namespace System;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class Camera;
}}}}

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class Camera
	{
	public:
		enum class FillModes
		{
			Wireframe,
			Solid,
		};

		[Flags]
		enum class DrawTypes
		{
			Grid				= 0x00000001,
			Light				= 0x00000002,

			Body				= 0x00000004,
			ViewVolume			= 0x00000008,
			Bone				= 0x00000010,

			KinematicCharacter	= 0x00000020,
			Collision			= 0x00000040,
			Joint				= 0x00000080,

			FramesPerSec		= 0x00000100,
			PrimitiveCount		= 0x00000200,

			None				= 0x00000000,
			Default				= 0x00000007,
			All					= 0x000003FF,
		};

	internal:
		Mix::Tool::Win32::Graphics::Camera* impl;

	public:
		/// <summary>
		/// RXgN^
		/// </summary>
		Camera( System::Windows::Forms::Control^ targetControl );
		/// <summary>
		/// fXgN^
		/// </summary>
		~Camera( void );

		/// <summary>
		/// wʂIł邩ǂ擾A܂͐ݒ
		/// </summary>
		property bool InvisibleSelection
		{
			bool get( void );
			void set( bool value );
		}

		/// <summary>
		/// tB[h̎擾A܂͐ݒ
		/// </summary>
		property Mix::Tool::Graphics::Camera::FillModes FillMode
		{
			Mix::Tool::Graphics::Camera::FillModes get( void );
			void set( Mix::Tool::Graphics::Camera::FillModes value );
		}

		/// <summary>
		/// `^Cv̎擾A܂͐ݒ
		/// </summary>
		property Mix::Tool::Graphics::Camera::DrawTypes DrawType
		{
			Mix::Tool::Graphics::Camera::DrawTypes get( void );
			void set( Mix::Tool::Graphics::Camera::DrawTypes value );
		}

		/// <summary>
		/// ^[QbgƂ̃ftHg̎擾A܂͐ݒ
		/// </summary>
		property float DefaultDistance
		{
			float get( void );
			void set( float value );
		}

		/// <summary>
		/// ^[QbgƂ̋̎擾A܂͐ݒ
		/// </summary>
		property float Distance
		{
			float get( void );
			void set( float value );
		}

		/// <summary>
		/// p̎擾A܂͐ݒ
		/// </summary>
		property Mix::Tool::Math::Vector^ Pose
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		/// <summary>
		/// ^[Qbg̎擾A܂͐ݒ
		/// </summary>
		property Mix::Tool::Math::Vector^ Target
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		/// <summary>
		/// [Jʒu̎擾
		/// </summary>
		property Mix::Tool::Math::Vector^ LocalPosition
		{
			Mix::Tool::Math::Vector^ get( void );
		}

		/// <summary>
		/// ʒu̎擾
		/// </summary>
		property Mix::Tool::Math::Vector^ Position
		{
			Mix::Tool::Math::Vector^ get( void );
		}

		/// <summary>
		/// ̎擾
		/// </summary>
		property Mix::Tool::Math::Vector^ Direction
		{
			Mix::Tool::Math::Vector^ get( void );
		}

		/// <summary>
		/// ܂
		/// </summary>
		void Initialize( Mix::Tool::Math::Vector^ localPos, Mix::Tool::Math::Vector^ target, Mix::Tool::Math::Vector^ pose );

		/// <summary>
		/// OړZbg܂
		/// </summary>
		void ResetDistation( void );
		/// <summary>
		/// Oړ܂
		/// </summary>
		void Distation( int d );
		
		/// <summary>
		/// ]Zbg܂
		/// </summary>
		void ResetRotation( void );
		/// <summary>
		/// ]܂
		/// </summary>
		void Rotation( int h, int v );

		/// <summary>
		/// ㉺EړZbg܂
		/// </summary>
		void ResetTranslation( void );
		/// <summary>
		/// ㉺Eړ܂
		/// </summary>
		void Translation( int h, int v );

		/// <summary>
		/// Cg]܂
		/// </summary>
		void RotationLight( int h, int v );
/*
		/// <summary>
		/// `IuWFNg̃XP[ÕZbgAbvs܂
		/// </summary>
		bool SetupScalingDrawObject( System::Drawing::Point^ point );
		/// <summary>
		/// `IuWFNg̃XP[Os܂
		/// </summary>
		void ScalingDrawObject( System::Drawing::Point^ point );

		/// <summary>
		/// `IuWFNg̃[e[Vs܂
		/// </summary>
		void RotationDrawObject( int h, int v );

		/// <summary>
		/// `IuWFNg̃gX[Vs܂
		/// </summary>
		void TranslationDrawObject( int h, int v );
*/
		/// <summary>
		/// `IuWFNg̃bVI( IuWFNgbV̂ )܂
		/// </summary>
		unsigned int SelectDrawObjectMesh( System::Drawing::Point^ point );

		/// <summary>
		/// XN[W[hԂ֕ϊ܂
		/// </summary>
		Mix::Tool::Math::Vector^ Unproject( Mix::Tool::Math::Vector^ point );
	};

}}}
