#include "Mix/Tool/CLR/Core/Graphics/DrawObject.h"

#include "Mix/Tool/Win32/Core/Graphics/MaterialSlot.h"
#include "Mix/Tool/Win32/Core/Graphics/DrawObject.h"
#include "Mix/Tool/CLR/Core/Graphics/MaterialSlotCollection.h"

namespace Mix{ namespace Tool{ namespace Graphics {

	////////////////////////////////////////////////////////////////////////////////////////////////////
// DrawObject
////////////////////////////////////////////////////////////////////////////////////////////////////

DrawObject::DrawObject( void ) :
implDrawObject( NULL ),
m_MaterialSlotCollection( gcnew Mix::Tool::Graphics::MaterialSlotCollection() )
{
}

DrawObject::~DrawObject( void )
{
	if( m_MaterialSlotCollection != nullptr )
	{
		delete m_MaterialSlotCollection;
	}

	implDrawObject = NULL;
}

void DrawObject::InitializeMaterialSlotCollection( void )
{
	if( m_MaterialSlotCollection->Count == 0 )
	{
		for( unsigned int i = 0; i < implDrawObject->GetMaterialSlotCount(); i++ )
		{
			m_MaterialSlotCollection->Add( implDrawObject->GetMaterialSlotByIndex( i ) );
		}
	}
	else
	{
		throw gcnew System::InvalidOperationException();
	}
}
/*
Mix::Tool::Math::Vector^ DrawObject::Scaling::get( void )
{
	const D3DXVECTOR3& s = implDrawObject->GetScaling();

	return gcnew Mix::Tool::Math::Vector( s.x, s.y, s.z, 1.0f );
}

void DrawObject::Scaling::set( Mix::Tool::Math::Vector^ value )
{
	implDrawObject->SetScaling( D3DXVECTOR3( value->x, value->y, value->z ) );
}

Mix::Tool::Math::Vector^ DrawObject::Rotation::get( void )
{
	const D3DXVECTOR3& r = implDrawObject->GetRotation();

	return gcnew Mix::Tool::Math::Vector( r.x, r.y, r.z, 1.0f );
}

void DrawObject::Rotation::set( Mix::Tool::Math::Vector^ value )
{
	implDrawObject->SetRotation( D3DXVECTOR3( value->x, value->y, value->z ) );
}

Mix::Tool::Math::Vector^ DrawObject::Translation::get( void )
{
	const D3DXVECTOR3& t = implDrawObject->GetTranslation();

	return gcnew Mix::Tool::Math::Vector( t.x, t.y, t.z, 1.0f );
}

void DrawObject::Translation::set( Mix::Tool::Math::Vector^ value )
{
	implDrawObject->SetTranslation( D3DXVECTOR3( value->x, value->y, value->z ) );
}
*/

void DrawObject::Enable( void )
{
	implDrawObject->Enable();
}

void DrawObject::Disable( void )
{
	implDrawObject->Disable();
}

int DrawObject::DisableCount::get( void )
{
	return implDrawObject->GetDisableCount();
}

Mix::Tool::Graphics::MaterialSlotCollection^ DrawObject::MaterialSlots::get( void )
{
	return m_MaterialSlotCollection;
}

bool DrawObject::SaveMaterials( void )
{
	return implDrawObject->SaveMaterials();
}

}}}
