#pragma once

#include "Mix/Tool/CLR/Core/Graphics/ShaderModels.h"
#include "Mix/Tool/CLR/Core/Graphics/ShaderProcessFlags.h"

using namespace System;
using namespace System::Drawing;

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class Manager;
}}}}

namespace Mix{ namespace Tool{ namespace Graphics
{
	public ref class Manager
	{
	public:
		ref class EffectPackageProperty
		{
		private:
			Mix::Tool::Win32::Graphics::Manager* implManager;

		internal:
			EffectPackageProperty( Mix::Tool::Win32::Graphics::Manager* _implManager );
			~EffectPackageProperty( void );

		public:
			property Mix::Tool::Graphics::ShaderModels Models
			{
				Mix::Tool::Graphics::ShaderModels get( void );
			}

			property Mix::Tool::Graphics::ShaderProcessFlags ProcessFlags
			{
				Mix::Tool::Graphics::ShaderProcessFlags get( void );
			}

			void Load(	Mix::Tool::Graphics::ShaderModels models,
						Mix::Tool::Graphics::ShaderProcessFlags procFlags,
						System::String^ directoryName,
						System::String^ name );

			void Save( void );

			void Compile( void );
			void Compile( System::Collections::Generic::List<System::String^>^ subDirList );
		};

		ref class PerspectiveProperty
		{
		private:
			Mix::Tool::Win32::Graphics::Manager* implManager;

		internal:
			PerspectiveProperty( Mix::Tool::Win32::Graphics::Manager* _implManager );
			~PerspectiveProperty( void );

		public:
			property float FovY
			{
				float get( void );
				void set( float value );
			}

			property float NearZ
			{
				float get( void );
				void set( float value );
			}

			property float FarZ
			{
				float get( void );
				void set( float value );
			}
		};

		ref class MouseSensitivityProperty
		{
		private:
			Mix::Tool::Win32::Graphics::Manager* implManager;

		internal:
			MouseSensitivityProperty( Mix::Tool::Win32::Graphics::Manager* _implManager );
			~MouseSensitivityProperty( void );

		public:
			property float Scaling
			{
				float get( void );
				void set( float value );
			}

			property float Rotation
			{
				float get( void );
				void set( float value );
			}

			property float Translation
			{
				float get( void );
				void set( float value );
			}
		};

	private:
		Mix::Tool::Win32::Graphics::Manager* impl;

		Mix::Tool::Graphics::ShaderModels m_SupportShaderModels;

		Manager::EffectPackageProperty^ m_EffectPackage;
		Manager::PerspectiveProperty^ m_Perspective;
		Manager::MouseSensitivityProperty^ m_MouseSensitivity;

	internal:
		Manager( void );
		~Manager( void );

		void Update( int baseFps, float fps, float mag );
		void Refresh( void );
		void Draw( void );

	public:
		property System::String^ RootDirectoryPath
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property Mix::Tool::Graphics::ShaderModels SupportShaderModels
		{
			Mix::Tool::Graphics::ShaderModels get( void );
		}

		property Manager::EffectPackageProperty^ EffectPackage
		{
			Manager::EffectPackageProperty^ get( void );
		}

		property Manager::PerspectiveProperty^ Perspective
		{
			Manager::PerspectiveProperty^ get( void );
		}

		property Manager::MouseSensitivityProperty^ MouseSensitivity
		{
			Manager::MouseSensitivityProperty^ get( void );
		}
	};

}}}
