#pragma once

#include "Mix/Tool/CLR/Core/Dynamics/Design/ITerrainDocument.h"
#include "Mix/Tool/CLR/Core/Graphics/Model.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Graphics{
	class MapModel;
}}}}

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class MapModel : public Mix::Tool::Graphics::Model, public Mix::Tool::Dynamics::Design::ITerrainDocument
	{
	public:
		ref class ImportConfig
		{
		private:
			System::String^ m_FilePath;

			Mix::Tool::Graphics::ModelImportOption m_Option;

			bool m_bSmooting;
			float m_SmootingAngle;

			float m_Scaling;
			Mix::Tool::Math::Vector^ m_Rotation;
			Mix::Tool::Math::Vector^ m_Translation;

			Mix::Tool::Math::Vector^ m_CellSize;

		public:
			ImportConfig( void );

		public:
			property System::String^ FilePath
			{
				System::String^ get( void );
				void set( System::String^ value );
			}

			property Mix::Tool::Graphics::ModelImportOption Option
			{
				Mix::Tool::Graphics::ModelImportOption get( void );
				void set( Mix::Tool::Graphics::ModelImportOption value );
			}

			property float Scaling
			{
				float get( void );
				void set( float value );
			}

			property Mix::Tool::Math::Vector^ Rotation
			{
				Mix::Tool::Math::Vector^ get( void );
				void set( Mix::Tool::Math::Vector^ value );
			}

			property Mix::Tool::Math::Vector^ Translation
			{
				Mix::Tool::Math::Vector^ get( void );
				void set( Mix::Tool::Math::Vector^ value );
			}

			property Mix::Tool::Math::Vector^ CellSize
			{
				Mix::Tool::Math::Vector^ get( void );
				void set( Mix::Tool::Math::Vector^ value );
			}

			property bool Smooting
			{
				bool get( void );
				void set( bool value );
			}

			property float SmootingAngle
			{
				float get( void );
				void set( float value );
			}
		};

	internal:
		Mix::Tool::Win32::Graphics::MapModel* implMapModel;

	private:
		Mix::Tool::Dynamics::Design::Terrain^ m_DynamicsDesigner;

	public:
		MapModel( void );
		virtual ~MapModel( void );

		bool Import( MapModel::ImportConfig^ config );
		bool ImportFinalize( void );

	public:
		virtual bool SaveModel( void ) override;

	public:
		property Mix::Tool::Dynamics::Design::Terrain^ DynamicsDesigner
		{
			virtual Mix::Tool::Dynamics::Design::Terrain^ get( void );
		}
	};

}}}
