#pragma once

#include "Mix/Tool/Win32/Core/Graphics/MaterialSlot.h"
#include "Mix/Tool/CLR/Core/Graphics/Material.h"

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class MaterialCollection : System::Collections::IEnumerable
	{
	private:
		Mix::Tool::Win32::Graphics::MaterialSlot* impl;
		System::Collections::Generic::List<Mix::Tool::Graphics::Material^>^ m_List;

	internal:
		MaterialCollection( Mix::Tool::Win32::Graphics::MaterialSlot* _impl );
		~MaterialCollection( void );

	public:
		property int Count
		{
			int get( void );
		}

		property Mix::Tool::Graphics::Material^ default[int]
		{
			Mix::Tool::Graphics::Material^ get( int index );
		}

		property Mix::Tool::Graphics::Material^ default[System::String^]
		{
			Mix::Tool::Graphics::Material^ get( System::String^ name );
		}

		property Mix::Tool::Graphics::Material^ ActiveMaterial
		{
			Mix::Tool::Graphics::Material^ get( void );
			void set( Mix::Tool::Graphics::Material^ value );
		}

		Mix::Tool::Graphics::Material^ Add( void );
		void Remove( Mix::Tool::Graphics::Material^ item );

		virtual System::Collections::IEnumerator^ GetEnumerator( void );
	};

}}}
