#include "Mix/Tool/CLR/Core/Graphics/MaterialSlot.h"

namespace Mix{ namespace Tool{ namespace Graphics{

////////////////////////////////////////////////////////////////////////////////////////////////////
// MaterialSlot::MaterialCollection
////////////////////////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////
// MaterialSlot
////////////////////////////////////////////////////////////////////////////////////////////////////

MaterialSlot::MaterialSlot( Mix::Tool::Win32::Graphics::MaterialSlot* _impl ) :
impl( _impl ),
m_MaterialCollection( gcnew Mix::Tool::Graphics::MaterialCollection( _impl ) )
{
}

MaterialSlot::~MaterialSlot( void )
{
	if( m_MaterialCollection != nullptr )
	{
		delete m_MaterialCollection;
	}

	impl = NULL;
}

System::String^ MaterialSlot::DefaultName::get( void )
{
	return gcnew System::String( impl->GetDefaultName() );
}

System::String^ MaterialSlot::Name::get( void )
{
	return gcnew System::String( impl->GetName() );
}

void MaterialSlot::Name::set( System::String^ value )
{
	pin_ptr<const wchar_t> wpName = PtrToStringChars( value );
	impl->SetName( wpName );
}

Mix::Tool::Graphics::MaterialCollection^ MaterialSlot::Materials::get( void )
{
	return m_MaterialCollection;
}

}}}
