#include "Mix/Tool/CLR/Core/Graphics/MaterialSlotCollection.h"

namespace Mix{ namespace Tool{ namespace Graphics{

MaterialSlotCollection::MaterialSlotCollection( void ) :
m_Selected( nullptr )
{
	m_List = gcnew System::Collections::Generic::List<Mix::Tool::Graphics::MaterialSlot^>();
}

MaterialSlotCollection::~MaterialSlotCollection( void )
{
	if( ( m_List != nullptr ) &&
		( m_List->Count > 0 ) )
	{
		for each ( Mix::Tool::Graphics::MaterialSlot^ materialSlot in m_List )
		{
			if( materialSlot != nullptr )
			{
				delete materialSlot;
			}
		}

		m_List->Clear();
	}

	m_Selected = nullptr;
}

void MaterialSlotCollection::Clear( void )
{
	if( m_List != nullptr )
	{
		m_List->Clear();
	}
}

void MaterialSlotCollection::Add( Mix::Tool::Win32::Graphics::MaterialSlot* implMaterialSlot )
{
	m_List->Add( gcnew Mix::Tool::Graphics::MaterialSlot( implMaterialSlot ) );

	if( m_List->Count == 1 )
	{
		m_Selected = m_List[0];
	}
}

void MaterialSlotCollection::Add( Mix::Tool::Graphics::MaterialSlot^ materialSlot )
{
	m_List->Add( materialSlot );

	if( m_List->Count == 1 )
	{
		m_Selected = m_List[0];
	}
}

bool MaterialSlotCollection::ContainsNyName( System::String^ name )
{
	for each ( Mix::Tool::Graphics::MaterialSlot^ materialSlot in m_List )
	{
		if( materialSlot->Name->Equals( name ) == true )
		{
			return true;
		}
	}

	return false;
}

int MaterialSlotCollection::Count::get( void )
{
	return m_List->Count;
}

Mix::Tool::Graphics::MaterialSlot^ MaterialSlotCollection::default::get( int index )
{
	try
	{
		return m_List[index];
	}
	catch( System::Exception^ )
	{
		throw;
	}
}

Mix::Tool::Graphics::MaterialSlot^ MaterialSlotCollection::default::get( System::String^ name )
{
	for each ( Mix::Tool::Graphics::MaterialSlot^ materialSlot in m_List )
	{
		if( materialSlot->Name->Equals( name ) == true )
		{
			return materialSlot;
		}
	}

	return nullptr;
}

Mix::Tool::Graphics::MaterialSlot^ MaterialSlotCollection::Selected::get( void )
{
	return m_Selected;
}

void MaterialSlotCollection::Selected::set( Mix::Tool::Graphics::MaterialSlot^ value )
{
	if( value == nullptr )
	{
		throw gcnew System::ArgumentNullException( L"Selected" );
	}

	if( m_List->Contains( value ) == true )
	{
		m_Selected = value;
	}
	else
	{
		throw gcnew System::ArgumentException( L"I悤Ƃ}eA̓RNVɑ݂܂" );
	}
}

System::Collections::IList^ MaterialSlotCollection::DataSource::get( void )
{
	return m_List;
}

System::Collections::IEnumerator^ MaterialSlotCollection::GetEnumerator( void )
{
	return m_List->GetEnumerator();
}

}}}
