#pragma once

#include "Mix/Tool/Win32/Core/Graphics/MaterialSlot.h"
#include "Mix/Tool/CLR/Core/Graphics/MaterialSlot.h"

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class MaterialSlotCollection : System::Collections::IEnumerable
	{
	private:
		System::Collections::Generic::List<Mix::Tool::Graphics::MaterialSlot^>^ m_List;
		Mix::Tool::Graphics::MaterialSlot^ m_Selected;

	internal:
		MaterialSlotCollection( void );
		~MaterialSlotCollection( void );

		void Clear( void );

		void Add( Mix::Tool::Win32::Graphics::MaterialSlot* implMaterialSlot );
		void Add( Mix::Tool::Graphics::MaterialSlot^ materialSlot );

		bool ContainsNyName( System::String^ name );

	public:
		property int Count
		{
			int get( void );
		}

		property Mix::Tool::Graphics::MaterialSlot^ default[int]
		{
			Mix::Tool::Graphics::MaterialSlot^ get( int index );
		}

		property Mix::Tool::Graphics::MaterialSlot^ default[System::String^]
		{
			Mix::Tool::Graphics::MaterialSlot^ get( System::String^ name );
		}

		property Mix::Tool::Graphics::MaterialSlot^ Selected
		{
			Mix::Tool::Graphics::MaterialSlot^ get( void );
			void set( Mix::Tool::Graphics::MaterialSlot^ value );
		}

		property System::Collections::IList^ DataSource
		{
			System::Collections::IList^ get( void );
		}

		virtual System::Collections::IEnumerator^ GetEnumerator( void );
	};

}}}
