#pragma once

#include "Mix/Tool/Win32/Core/Graphics/Model.h"
#include "Mix/Tool/CLR/Core/Graphics/DrawObject.h"
#include "Mix/Tool/CLR/Core/Graphics/Node.h"

using namespace System;

namespace Mix{ namespace Tool{ namespace Graphics{

	public enum class ModelImportOption
	{
		Default = 0,

		FBX_Maya = 1,
		FBX_3DStudioMax = 2,
	};

	public ref class Model abstract : public DrawObject
	{
	internal:
		Mix::Tool::Win32::Graphics::Model* implModel;

		Mix::Tool::Graphics::Node^ m_RootNode;
		Mix::Tool::Graphics::Node^ m_SelectedNode;
		Mix::Tool::Graphics::MeshNode^ m_SelectedMeshNode;

		System::Collections::Generic::Dictionary<unsigned int, Mix::Tool::Graphics::Node^>^ m_MeshNodeMap;

	public:
		Model( void );
		virtual ~Model( void );

	public:
		property System::String^ ModelFilePath
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property System::String^ Name
		{
			System::String^ get( void );
		}

		property Mix::Tool::Graphics::Node^ RootNode
		{
			Mix::Tool::Graphics::Node^ get( void );
		}

		property Mix::Tool::Graphics::Node^ SelectedNode
		{
			Mix::Tool::Graphics::Node^ get( void );
			void set( Mix::Tool::Graphics::Node^ value );
		}

		property unsigned int SelectedMeshKey
		{
			unsigned int get( void );
			void set( unsigned int value );
		}

		virtual bool SaveModel( void ) = 0;

	protected:
		void InitializeNodeTree( void );
		void ReleaseNodeTree( void );

		Mix::Tool::Win32::Graphics::Model::IMPORT_OPTION_TYPE ToWin32ImportOption( Mix::Tool::Graphics::ModelImportOption opt );

	private:
		Mix::Tool::Graphics::Node^ BuildNodeTree( Mix::Tool::Win32::Graphics::Node* implNode );
		void BuildNodeTree( Mix::Tool::Graphics::Node^ parentNode, Mix::Tool::Win32::Graphics::Node* implNode );
		Mix::Tool::Graphics::Node^ CreateNode( Mix::Tool::Win32::Graphics::Node* implNode );
	};

}}}
