#pragma once

#include "Mix/Tool/Win32/Core/Graphics/Motion.h"
#include "Mix/Tool/CLR/Core/Graphics/MotionCurve.h"
#include "Mix/Tool/CLR/Core/Graphics/MotionState.h"
#include "Mix/Tool/CLR/Core/Graphics/RootTransformFlags.h"

using namespace System;
using namespace System::Collections::Generic;

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class Motion
	{
	public:
		ref class CurveCollection : System::Collections::IEnumerable
		{
		internal:
			System::Collections::Generic::List<Mix::Tool::Graphics::MotionCurve^>^ m_List;
			System::Collections::Generic::Dictionary<System::String^,int>^ m_IndexDic;

		internal:
			CurveCollection( Mix::Tool::Win32::Graphics::Motion* _implMotion );
			~CurveCollection( void );

		public:
			property int Count
			{
				int get( void );
			}

			property Mix::Tool::Graphics::MotionCurve^ default[int]
			{
				Mix::Tool::Graphics::MotionCurve^ get( int index );
			}

			property Mix::Tool::Graphics::MotionCurve^ default[System::String^]
			{
				Mix::Tool::Graphics::MotionCurve^ get( System::String^ name );
			}

			virtual System::Collections::IEnumerator^ GetEnumerator( void );
		};

	internal:
		Mix::Tool::Win32::Graphics::Motion* impl;
		Motion::CurveCollection^ m_Curves;

	internal:
		Motion( Mix::Tool::Win32::Graphics::Motion* _impl );

	public:
		~Motion( void );

		property System::String^ DefaultName
		{
			System::String^ get( void );
		}

		property System::String^ Name
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property bool Assigned
		{
			bool get( void );
		}

		property bool Default
		{
			bool get( void );
			void set( bool value );
		}

		property int LastTime
		{
			int get( void );
		}

		property float BlendRatio
		{
			float get( void );
			void set( float value );
		}

		property bool Loop
		{
			bool get( void );
			void set( bool value );
		}

		property float Speed
		{
			float get( void );
			void set( float value );
		}

		property int LoopStartTime
		{
			int get( void );
			void set( int value );
		}

		property int LoopEndTime
		{
			int get( void );
			void set( int value );
		}

		property int Time
		{
			int get( void );
			void set( int value );
		}

		property System::String^ SaveFilePath
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property MotionState State
		{
			MotionState get( void );
		}

		property Motion::CurveCollection^ Curves
		{
			Motion::CurveCollection^ get( void );
		}

		property Mix::Tool::Graphics::RootTransformFlags RootTransform
		{
			Mix::Tool::Graphics::RootTransformFlags get( void );
			void set( Mix::Tool::Graphics::RootTransformFlags value );
		}

		void Play( void );
		void Pause( void );
		void Stop( void );
	};

}}}
