#pragma once

#include "Mix/Tool/Win32/Core/Graphics/MotionController.h"
#include "Mix/Tool/CLR/Core/Graphics/Motion.h"

using namespace System;
using namespace System::Collections::Generic;

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class MotionController
	{
	public:
		ref class MotionCollection : System::Collections::IEnumerable
		{
		private:
			Mix::Tool::Win32::Graphics::MotionController* impl;
			System::Collections::Generic::List<Mix::Tool::Graphics::Motion^>^ m_List;

		internal:
			MotionCollection( void );
			~MotionCollection( void );

			void Initialize( Mix::Tool::Win32::Graphics::MotionController* _impl );

		public:
			property int Count
			{
				int get( void );
			}

			property Mix::Tool::Graphics::Motion^ default[int]
			{
				Mix::Tool::Graphics::Motion^ get( int index );
			}

			property Mix::Tool::Graphics::Motion^ default[System::String^]
			{
				Mix::Tool::Graphics::Motion^ get( System::String^ name );
			}

			void Add( Mix::Tool::Graphics::Motion^ item );
			void Remove( Mix::Tool::Graphics::Motion^ item );

			virtual System::Collections::IEnumerator^ GetEnumerator( void );
		};

	internal:
		Mix::Tool::Win32::Graphics::MotionController* impl;
		MotionController::MotionCollection^ m_Motions;

	internal:
		MotionController( void );

		void Initialize( Mix::Tool::Win32::Graphics::MotionController* _impl );

	public:
		~MotionController( void );

		property bool Assigned
		{
			bool get( void );
		}

		property System::String^ Name
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property unsigned int Priority
		{
			unsigned int get( void );
			void set( unsigned int value );
		}

		property MotionController::MotionCollection^ Motions
		{
			MotionController::MotionCollection^ get( void );
		}
	};

}}}
