#include "Mix/Tool/CLR/Core/Graphics/MotionControllerCollection.h"

namespace Mix{ namespace Tool{ namespace Graphics{

MotionControllerCollection::MotionControllerCollection( Mix::Tool::Win32::Graphics::ObjectModel* _impl ) :
impl( _impl ),
m_List( gcnew System::Collections::Generic::List<Mix::Tool::Graphics::MotionController^>() )
{
}

MotionControllerCollection::~MotionControllerCollection( void )
{
	if( m_List->Count > 0 )
	{
		for each ( Mix::Tool::Graphics::MotionController^ controller in m_List )
		{
			delete controller;
		}

		m_List->Clear();
	}

	impl = NULL;
}

void MotionControllerCollection::Initialize( void )
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// XgVKɍ쐬
	////////////////////////////////////////////////////////////////////////////////////////////////////

	unsigned int count = impl->GetMotionControllerCount();

	for( unsigned int i = 0; i < count; i++ )
	{
		Mix::Tool::Win32::Graphics::MotionController* implController = impl->GetMotionControllerByIndex( i );

		Mix::Tool::Graphics::MotionController^ controller = gcnew Mix::Tool::Graphics::MotionController();
		if( controller == nullptr )
		{
			throw gcnew System::OutOfMemoryException();
		}

		try
		{
			controller->Initialize( implController );
			m_List->Add( controller );
		}
		catch( System::Exception^ )
		{
			throw;
		}
	}
}

int MotionControllerCollection::Count::get( void )
{
	return m_List->Count;
}

Mix::Tool::Graphics::MotionController^ MotionControllerCollection::default::get( int index )
{
	return m_List[index];
}

Mix::Tool::Graphics::MotionController^ MotionControllerCollection::Add( void )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException( L"[VRg[[RNVĂȂAɉĂ邽߁Ȃ͍s܂" );
	}

	Mix::Tool::Win32::Graphics::MotionController* implController = impl->AddMotionController();
	if( implController == NULL )
	{
		throw gcnew System::OutOfMemoryException();
	}

	Mix::Tool::Graphics::MotionController^ controller = gcnew Mix::Tool::Graphics::MotionController();
	if( controller == nullptr )
	{
		throw gcnew System::OutOfMemoryException();
	}

	try
	{
		controller->Initialize( implController );
		m_List->Add( controller );
	}
	catch( System::Exception^ )
	{
		throw;
	}

	return controller;
}

void MotionControllerCollection::Remove( Mix::Tool::Graphics::MotionController^ item )
{
	if( impl == NULL )
	{
		throw gcnew System::InvalidOperationException( L"[VRg[[RNVĂȂAɉĂ邽߁Ȃ͍s܂" );
	}

	if( item == nullptr )
	{
		throw gcnew System::ArgumentNullException( "item" );
	}

	if( item->impl == NULL )
	{
		throw gcnew System::ArgumentException( "폜悤Ƃ[VRg[[͊ɉĂ܂" );
	}

	if( m_List->Contains( item ) == false )
	{
		throw gcnew System::Exception( "IuWFNgfɊ܂܂ĂȂ[VRg[[폜悤Ƃ܂" );
	}

	m_List->Remove( item );
	impl->RemoveMotionController( item->impl );
}

void MotionControllerCollection::Sort( void )
{
	MotionControllerCollection::SortList^ sortList = gcnew MotionControllerCollection::SortList();

	m_List->Sort( sortList );

	delete sortList;
}

System::Collections::IEnumerator^ MotionControllerCollection::GetEnumerator( void )
{
	return m_List->GetEnumerator();
}

}}}
