#pragma once

#include "Mix/Tool/CLR/Core/Graphics/MotionController.h"

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class MotionControllerCollection : System::Collections::IEnumerable
	{
	private:
		ref class SortList : public System::Collections::Generic::IComparer<Mix::Tool::Graphics::MotionController^>
		{
		public:
			virtual int Compare( Mix::Tool::Graphics::MotionController^ l, Mix::Tool::Graphics::MotionController^ r )
			{
				return r->Priority - l->Priority;
			}
		};

	private:
		Mix::Tool::Win32::Graphics::ObjectModel* impl;

		System::Collections::Generic::List<Mix::Tool::Graphics::MotionController^>^ m_List;

	internal:
		MotionControllerCollection( Mix::Tool::Win32::Graphics::ObjectModel* _impl );
		~MotionControllerCollection( void );

		void Initialize( void );

	public:
		property int Count
		{
			int get( void );
		}

		property Mix::Tool::Graphics::MotionController^ default[int]
		{
			Mix::Tool::Graphics::MotionController^ get( int index );
		}

		Mix::Tool::Graphics::MotionController^ Add( void );
		void Remove( Mix::Tool::Graphics::MotionController^ item );
		void Sort( void );

		virtual System::Collections::IEnumerator^ GetEnumerator( void );
	};

}}}
