#pragma once

#include "Mix/Tool/Win32/Core/Graphics/ObjectModel.h"

#include "Mix/Tool/CLR/Core/Graphics/RootTransformAxis.h"
#include "Mix/Tool/CLR/Core/Graphics/RootTransformFlags.h"
#include "Mix/Tool/CLR/Core/Graphics/RootTransformHorizonal.h"
#include "Mix/Tool/CLR/Core/Graphics/RootTransformVertical.h"

namespace Mix{ namespace Tool{ namespace Graphics{

	public ref class RootTransform
	{
	private:
		Mix::Tool::Win32::Graphics::ObjectModel* impl;
		bool m_bUpdate;

	internal:
		RootTransform( Mix::Tool::Win32::Graphics::ObjectModel* _impl );
		~RootTransform( void );

	private:
		void Update( void );
		Mix::Tool::Graphics::RootTransformVector ToCLRVector( Mix::Tool::Win32::Graphics::MOTION_RT_VECTOR src );
		Mix::Tool::Win32::Graphics::MOTION_RT_VECTOR ToWIN32Vector( Mix::Tool::Graphics::RootTransformVector src );

	public:
		property Mix::Tool::Graphics::RootTransformFlags Active
		{
			Mix::Tool::Graphics::RootTransformFlags get( void );
			void set( Mix::Tool::Graphics::RootTransformFlags value );
		}

		property System::String^ NodeName
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property Mix::Tool::Graphics::RootTransformAxis^ RotationAxis
		{
			Mix::Tool::Graphics::RootTransformAxis^ get( void );
			void set( Mix::Tool::Graphics::RootTransformAxis^ value );
		}

		property Mix::Tool::Graphics::RootTransformHorizonal TranslationHorizonal
		{
			Mix::Tool::Graphics::RootTransformHorizonal get( void );
			void set( Mix::Tool::Graphics::RootTransformHorizonal value );
		}

		property Mix::Tool::Graphics::RootTransformVertical TranslationVertical
		{
			Mix::Tool::Graphics::RootTransformVertical get( void );
			void set( Mix::Tool::Graphics::RootTransformVertical value );
		}

		property Mix::Tool::Graphics::RootTransformAxis^ TranslationAxis
		{
			Mix::Tool::Graphics::RootTransformAxis^ get( void );
			void set( Mix::Tool::Graphics::RootTransformAxis^ value );
		}

		void BeginUpdate( void );
		void EndUpdate( void );
	};
}}}
