#include "Mix/Tool/CLR/Core/Graphics/RootTransformAxis.h"

namespace Mix{ namespace Tool{ namespace Graphics{

RootTransformAxis::RootTransformAxis( void )
{
	x = Mix::Tool::Graphics::RootTransformVector::PositiveX;
	y = Mix::Tool::Graphics::RootTransformVector::PositiveY;
	z = Mix::Tool::Graphics::RootTransformVector::PositiveZ;
}

RootTransformAxis::RootTransformAxis(	Mix::Tool::Graphics::RootTransformVector _x,
										Mix::Tool::Graphics::RootTransformVector _y,
										Mix::Tool::Graphics::RootTransformVector _z )
{
	x = _x;
	y = _y;
	z = _z;
}

Mix::Tool::Graphics::RootTransformVector RootTransformAxis::X::get( void )
{
	return x;
}

void RootTransformAxis::X::set( Mix::Tool::Graphics::RootTransformVector value )
{
	x = value;
}

Mix::Tool::Graphics::RootTransformVector RootTransformAxis::Y::get( void )
{
	return y;
}

void RootTransformAxis::Y::set( Mix::Tool::Graphics::RootTransformVector value )
{
	y = value;
}

Mix::Tool::Graphics::RootTransformVector RootTransformAxis::Z::get( void )
{
	return z;
}

void RootTransformAxis::Z::set( Mix::Tool::Graphics::RootTransformVector value )
{
	z = value;
}

System::String^ RootTransformAxis::ToString()
{
	System::String^ temp = gcnew System::String(L"");

	temp += x.ToString() + L"," + y.ToString() + L"," + z.ToString();

	return temp;
}

RootTransformAxis^ RootTransformAxis::Parse( System::String^ str )
{
	array<wchar_t>^ tokn= { L',' };
	array<System::String^>^ strList = nullptr;
	RootTransformAxis^ ret = gcnew RootTransformAxis();

	strList = str->Split( tokn );

	if( strList->Length != 3 )
	{
		return ret;
	}

	try
	{
		ret->X = ( RootTransformVector )System::Enum::Parse( RootTransformVector::typeid, strList[0] );
		ret->Y = ( RootTransformVector )System::Enum::Parse( RootTransformVector::typeid, strList[1] );
		ret->Z = ( RootTransformVector )System::Enum::Parse( RootTransformVector::typeid, strList[2] );
	}
	catch( System::Exception^ )
	{
		throw;
	}

	return ret;
}

}}}
