#pragma once

#include "Mix/Tool/Win32/Core/Graphics/Scene.h"

#include "Mix/Tool/CLR/Core/Graphics/Camera.h"
#include "Mix/Tool/CLR/Core/Graphics/DrawObject.h"
#include "Mix/Tool/CLR/Core/Dynamics/World.h"

using namespace System;

namespace Mix{ namespace Tool{ namespace Graphics
{
	public ref class GeneralProperty
	{
	private:
		Mix::Tool::Win32::Graphics::Scene* impl;
		bool m_bSelectedAlwaysDisplay;

	internal:
		GeneralProperty( Mix::Tool::Win32::Graphics::Scene* _impl );
		~GeneralProperty( void );

	public:
		property Mix::Tool::Math::Vector^ BackgroundColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ TextColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ BoneColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ ViewVolumeColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ KinematicCharacterColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ SensorColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ CollisionColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ JointAxisColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ JointBallColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ JointLimitColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property float JointScale
		{
			float get( void );
			void set( float value );
		}

		property Mix::Tool::Math::Vector^ SelectedColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property bool SelectedAlwaysDisplay
		{
			bool get( void );
			void set( bool value );
		};

		property float AxisScale
		{
			float get( void );
			void set( float value );
		}
	};

	public ref class GridProperty
	{
	private:
		Mix::Tool::Win32::Graphics::Scene* impl;

	internal:
		GridProperty( Mix::Tool::Win32::Graphics::Scene* _impl );
		~GridProperty( void );

	public:
		property Mix::Tool::Math::Vector^ Color
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property float Pitch
		{
			float get( void );
			void set( float );
		}

		property float Extent
		{
			float get( void );
			void set( float value );
		}
	};

	public ref class LightProperty
	{
	private:
		Mix::Tool::Win32::Graphics::Scene* impl;

	internal:
		LightProperty( Mix::Tool::Win32::Graphics::Scene* _impl );
		~LightProperty( void );

	public:
		property Mix::Tool::Math::Vector^ AmbientColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property Mix::Tool::Math::Vector^ DiffuseColor
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

		property float Shading
		{
			float get( void );
			void set( float value );
		}

		property float Scale
		{
			float get( void );
			void set( float value );
		}

		property Mix::Tool::Math::Vector^ Pose
		{
			Mix::Tool::Math::Vector^ get( void );
			void set( Mix::Tool::Math::Vector^ value );
		}

	public:
		void ResetPose( void );
	};

	public ref class CameraCollection
	{
	private:
		Mix::Tool::Win32::Graphics::Scene* impl;

	internal:
		CameraCollection( Mix::Tool::Win32::Graphics::Scene* _impl );
		~CameraCollection( void );

	public:
		void Add( Mix::Tool::Graphics::Camera^ camera );
		void Remove( Mix::Tool::Graphics::Camera^ camera );
	};

	public ref class Scene
	{
	private:
		Mix::Tool::Win32::Graphics::Scene* impl;

	private:
		Mix::Tool::Graphics::GeneralProperty^ m_GeneProp;
		Mix::Tool::Graphics::GridProperty^ m_GridProp;
		Mix::Tool::Graphics::LightProperty^ m_LightProp;
		Mix::Tool::Graphics::CameraCollection^ m_Cameras;

		Mix::Tool::Graphics::DrawObject^ m_DrawObject;

	public:
		Scene( void );
		~Scene( void );

	public:
		property Mix::Tool::Graphics::GeneralProperty^ General
		{
			Mix::Tool::Graphics::GeneralProperty^ get( void );
		}

		property Mix::Tool::Graphics::GridProperty^ Grid
		{
			Mix::Tool::Graphics::GridProperty^ get( void );
		}

		property Mix::Tool::Graphics::LightProperty^ Light
		{
			Mix::Tool::Graphics::LightProperty^ get( void );
		}

		property Mix::Tool::Graphics::CameraCollection^ Cameras
		{
			Mix::Tool::Graphics::CameraCollection^ get( void );
		}

		property Mix::Tool::Graphics::DrawObject^ DrawObject
		{
			Mix::Tool::Graphics::DrawObject^ get( void );
			void set( Mix::Tool::Graphics::DrawObject^ value );
		}

		property System::String^ ReflectionTextureFileName
		{
			System::String^ get( void );
			void set( System::String^ value );
		}
	};

}}}
