#include "Mix/Tool/CLR/Core/Utility/DefinitionOrderTypeConverter.h"

namespace Mix{ namespace Tool{ namespace Utility{

System::ComponentModel::PropertyDescriptorCollection^ DefinitionOrderTypeConverter::GetProperties( System::ComponentModel::ITypeDescriptorContext^ context, System::Object^ value, array<System::Attribute^>^ attributes )
{
	System::ComponentModel::PropertyDescriptorCollection^ propDescs = System::ComponentModel::TypeDescriptor::GetProperties( value, attributes );
	System::Type^ type = value->GetType();
	System::Collections::Generic::List<System::String^>^ list = gcnew System::Collections::Generic::List<System::String^>();

	for each ( System::Reflection::PropertyInfo^ propInfo in type->GetProperties() )
	{
		list->Add( propInfo->Name );
	}

	list->Reverse( 0, list->Count );

	return propDescs->Sort( list->ToArray() );
}

bool DefinitionOrderTypeConverter::GetPropertiesSupported( System::ComponentModel::ITypeDescriptorContext^ context )
{
	return true;
}

}}}
