#include "Mix/Tool/CLR/Core/Utility/NamingService.h"

namespace Mix{ namespace Tool{ namespace Utility{

NamingService::NamingService( void ) :
m_List( gcnew System::Collections::Generic::List<System::String^>() )
{
}

System::String^ NamingService::Add( System::String^ name )
{
	System::String^ baseName = L"";
	System::String^ newName = L"";

	if( ( name == nullptr ) ||
		( name->Length == 0 ) )
	{
		baseName = L"";
	}
	else
	{
		baseName = name;
	}

	if( m_List->Contains( name ) == true )
	{
		int number;

		for( number = 1; ( number <= MAX_NUMBER ) && ( newName->Length == 0 ); number++ )
		{
			System::String^ tempName = System::String::Format( L"{0}_{1:D3}", name, number );

			if( m_List->Contains( tempName ) == false )
			{
				newName = tempName;
			}
		}

		if( number > MAX_NUMBER )
		{
			throw gcnew OverlapNumberException();
		}
	}
	else
	{
		newName = name;
	}

	m_List->Add( newName );

	return newName;
}

void NamingService::Remove( System::String^ name )
{
	if( m_List->Contains( name ) == true )
	{
		m_List->Remove( name );
	}
}

}}}
