#pragma once

#include "Types.h"

namespace Mix{ namespace Tool{ namespace Font{

	public ref class TextCollection
	{
	internal:
		System::Collections::Generic::List<System::String^>^ m_List;

	internal:
		TextCollection( void );

	public:
		property int Count
		{
			int get( void );
		}

		property System::String^ default[int]
		{
			System::String^ get( int index );
		}

		void Clear( void );
		void Add( System::String^ fileName );
		void Remove( System::String^ fileName );
		void Remove( int index );
	};

	public ref class Creator
	{
	public:
		static const int DefSize = 16;
		static const int DefWeight = 400;

	private:
		static const unsigned int MAGICNUMBER = 0x4652504D;
		static const unsigned int VERSION = 0x01020000;
		static const unsigned int MAX_CHARACTER_BITTABLE = 2048;
		static const unsigned int MAX_FILESIZE = 16777215;

	public:
		enum class State
		{
			Start = 0,
			Complete = 1,
			Error = -1,
		};

		delegate void DelegateProgress( int progress );
		delegate void DelegateChangeState( Creator::State state );

	private:
		System::String^ m_Style;
		unsigned int m_Size;
		unsigned int m_Weight;
		Mix::Tool::Font::Effects m_Effects;
		unsigned int m_BorderSize;
		Mix::Tool::Font::TextCollection^ m_Texts;
		Creator::DelegateProgress^ m_Progress;
		Creator::DelegateChangeState^ m_ChangeState;
		System::String^ m_FilePath;

	private:
		void InvokeProgress( int progress );
		void InvokeChangeState( Creator::State state );

		bool CreateCharacterBitTableFromText( unsigned int* pBitTable );
		void CreateCharacterBitTableFromTable( unsigned int* pBitTable );

	public:
		Creator( void );
		~Creator( void );

	public:
		property System::String^ Style
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property int Size
		{
			int get( void );
			void set( int value );
		}

		property int Weight
		{
			int get( void );
			void set( int value );
		}

		property Mix::Tool::Font::Effects Effects
		{
			Mix::Tool::Font::Effects get( void );
			void set( Mix::Tool::Font::Effects value );
		}

		property int BorderSize
		{
			int get( void );
			void set( int value );
		}

		property bool IsBordering
		{
			bool get( void );
		}

		property Mix::Tool::Font::TextCollection^ Texts
		{
			Mix::Tool::Font::TextCollection^ get( void );
		}

		property System::String^ FilePath
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

	public:
		property Creator::DelegateProgress^ Progress
		{
			void set( Creator::DelegateProgress^ value );
		}

		property Creator::DelegateChangeState^ ChangeState
		{
			void set( Creator::DelegateChangeState^ value );
		}

	public:
		void Run( void );
	};

}}}