#include "Stdafx.h"
#include "StyleCollection.h"

#include <string>
#include <list>

namespace Mix{ namespace Tool{ namespace Font{

////////////////////////////////////////////////////////////////////////////////////////////////////
// tHg񋓗p֐
////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma unmanaged

int CALLBACK EnumFontFamExProc( ENUMLOGFONTEX* lpelfe, NEWTEXTMETRICEX* lpntme, DWORD FontType, LPARAM lParam )
{
	std::list<std::wstring>* pFontNameList = reinterpret_cast<std::list<std::wstring>*>( lParam );
/*
	System::Diagnostics::Debug::Write( gcnew System::String( lpelfe->elfFullName ) );
	System::Diagnostics::Debug::Write( gcnew System::String( L" : " ) );
	System::Diagnostics::Debug::Write( gcnew System::String( lpelfe->elfStyle ) );
	System::Diagnostics::Debug::Write( gcnew System::String( L" : " ) );
	System::Diagnostics::Debug::Write( gcnew System::String( lpelfe->elfScript ) );
	System::Diagnostics::Debug::Write( gcnew System::String( L"\n" ) );
*/
	if( lpelfe->elfFullName[0] != L'@' )
	{
		pFontNameList->push_back( lpelfe->elfFullName );
	}

	return 1;
}

#pragma managed

////////////////////////////////////////////////////////////////////////////////////////////////////
// StyleCollection
////////////////////////////////////////////////////////////////////////////////////////////////////

StyleCollection::StyleCollection( System::IntPtr handle ) :
m_List( gcnew System::Collections::Generic::List<System::String^>() )
{
	HDC hDC;
	LOGFONT logFont;
	std::list<std::wstring> fontStyleList;

	hDC = ::GetDC( static_cast<HWND>( handle.ToPointer() ) );

	::ZeroMemory( &logFont, sizeof( logFont ) );
	logFont.lfCharSet = SHIFTJIS_CHARSET;
	logFont.lfItalic = FALSE;
	logFont.lfUnderline = FALSE;
	logFont.lfStrikeOut = FALSE;
	logFont.lfOutPrecision = OUT_DEFAULT_PRECIS;
	logFont.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	logFont.lfQuality = PROOF_QUALITY;
	logFont.lfPitchAndFamily = FIXED_PITCH | FF_MODERN;

	::EnumFontFamiliesEx( hDC, &logFont, reinterpret_cast<FONTENUMPROC>( Mix::Tool::Font::EnumFontFamExProc ), reinterpret_cast<LPARAM>( &fontStyleList ), 0 );
	if( fontStyleList.size() > 0 )
	{
		fontStyleList.sort();

		for( std::list<std::wstring>::iterator it = fontStyleList.begin(); it != fontStyleList.end(); ++it )
		{
			m_List->Add( gcnew System::String( ( *it ).c_str() ) );
		}
	}
}

StyleCollection::~StyleCollection( void )
{
	m_List->Clear();
}

int StyleCollection::Count::get( void )
{
	return m_List->Count;
}

System::String^ StyleCollection::default::get( int index )
{
	return m_List[index];
}

}}}
