#pragma once

#include "Types.h"

namespace Mix{ namespace Tool{ namespace Font{

	public ref class Viewer
	{
	private:
		HWND m_hWnd;
		HDC m_hWndDC;

		HBITMAP m_hBmp;
		void* m_pBmpBits;
		HDC m_hBmpDC;
		UINT m_BmpWidth;
		UINT m_BmpHeight;
		UINT m_BmpSize;

		System::String^ m_Style;
		unsigned int m_Size;
		unsigned int m_Weight;
		Mix::Tool::Font::Effects m_Effects;
		unsigned int m_BorderSize;

		unsigned int m_FontSize;
		unsigned int m_MaxBorderSize;

		UINT m_ForeColor;

		BYTE* m_pGlyphBuff;
		UINT m_GlyphBuffSize;

		BYTE* m_pGlyphImage;
		UINT m_GlyphImageSize;

		HFONT m_hFont;
		HPEN m_hGridPen;

		UINT m_HNum;
		UINT m_VNum;

		UINT m_ScrollMax;
		UINT m_ScrollPos;
	
	public:
		Viewer( System::IntPtr handle );
		~Viewer( void );

		property System::String^ Style
		{
			System::String^ get( void );
			void set( System::String^ value );
		}

		property int Size
		{
			int get( void );
			void set( int value );
		}

		property int Weight
		{
			int get( void );
			void set( int value );
		}

		property Mix::Tool::Font::Effects Effects
		{
			Mix::Tool::Font::Effects get( void );
			void set( Mix::Tool::Font::Effects value );
		}

		property int BorderSize
		{
			int get( void );
			void set( int value );
		}

		property int MinBorderSize
		{
			int get( void );
		}

		property int MaxBorderSize
		{
			int get( void );
		}

		property int ScrollMaximum
		{
			int get( void );
		}

		property int ScrollValue
		{
			int get( void );
			void set( int value );
		}

		event System::EventHandler^ BorderRangeChanged;

		void Update( void );
		void Draw( void );

	private:
		void UpdateFont( void );
		void DrawFont( UINT x, UINT y, UINT code );

	private:
		static const COLORREF GRID_COLOR = RGB( 208, 208, 208 );
		static const int MIN_SIZE = 8;
		static const int MIN_BORDER_SIZE = 1;
	};

}}}
