#pragma once

namespace Mix{ namespace Tool
{
	public ref class Logger
	{
	private:
		const static unsigned int WPARAM_CLEAR = 0;
		const static unsigned int WPARAM_PRINT = 1;

	public:
		enum class Type
		{
			Info = 0,
			Warning = 1,
			Error = 2,
		};

		delegate void DelegateProcClear( void );
		delegate void DelegateProcPrint( Mix::Tool::Logger::Type type, System::String^ str );

		static property System::IntPtr Handle
		{
			System::IntPtr get( void );
			void set( System::IntPtr value );
		};

		static property int Msg
		{
			int get( void );
			void set( int value );
		}

		static property Mix::Tool::Logger::DelegateProcClear^ ProcClear
		{
			void set( Mix::Tool::Logger::DelegateProcClear^ value );
		}

		static property Mix::Tool::Logger::DelegateProcPrint^ ProcPrint
		{
			void set( Mix::Tool::Logger::DelegateProcPrint^ value );
		}

		static void Clear( void );
		static void Print( Mix::Tool::Logger::Type type, System::String^ str );

		static void WndProc( System::Windows::Forms::Message^ msg );
	};
}}
