#pragma once

#include "Mix/Tool/CLR/Math/Vector.h"
#include "Mix/Tool/CLR/Math/Matrix.h"

using namespace System;

namespace Mix{ namespace Tool{ namespace Math{

	//NH[^jINX
	public ref class Quaternion
	{
	private:
		float x;
		float y;
		float z;
		float w;

	public:
		Quaternion( void );
		Quaternion( Quaternion% q );
		Quaternion( Quaternion^ q );
		Quaternion( float _x, float _y, float _z, float _w );

		property float X
		{
			float get( void );
			void set( float value );
		}

		property float Y
		{
			float get( void );
			void set( float value );
		}

		property float Z
		{
			float get( void );
			void set( float value );
		}

		property float W
		{
			float get( void );
			void set( float value );
		}

		property Mix::Tool::Math::Vector^ Axis
		{
			Mix::Tool::Math::Vector^ get( void );
		}

		property float Angle
		{
			float get( void );
		}

		property Mix::Tool::Math::Matrix^ Matrix
		{
			Mix::Tool::Math::Matrix^ get( void );
		}

		void SetRotationAxis( Mix::Tool::Math::Vector^ axis, float angle );
		void RotationAxis( Mix::Tool::Math::Vector^ axis, float angle );

		void Normalize( void );

		virtual System::String^ ToString() override;
		static Quaternion^ Parse( System::String^ str );
	};

}}}
