#pragma once

using namespace System;
using namespace System::ComponentModel;

namespace Mix{ namespace Tool{ namespace Math{

	ref class Vector;

	public ref class VectorConverter : System::ComponentModel::ExpandableObjectConverter
	{
	public:
		virtual bool CanConvertFrom( System::ComponentModel::ITypeDescriptorContext^ context, System::Type^ sourceType ) override;
		virtual System::Object^ ConvertFrom( System::ComponentModel::ITypeDescriptorContext^ context, System::Globalization::CultureInfo^ culture, System::Object^ obj ) override;

		virtual bool CanConvertTo( System::ComponentModel::ITypeDescriptorContext^ context, System::Type^ destinationType ) override;
		virtual System::Object^ ConvertTo( System::ComponentModel::ITypeDescriptorContext^ context, System::Globalization::CultureInfo^ culture, System::Object^ value, System::Type^ destinationType ) override;

		virtual System::Object^ CreateInstance( System::ComponentModel::ITypeDescriptorContext^ context, System::Collections::IDictionary^ propertyValues ) override;

		virtual bool GetCreateInstanceSupported( System::ComponentModel::ITypeDescriptorContext^ context ) override;
		virtual bool GetPropertiesSupported( System::ComponentModel::ITypeDescriptorContext^ context ) override;
	};

	public ref class Vector
	{
	private:
		float x;
		float y;
		float z;
		float w;

	public:
		Vector( void );
		Vector( Vector% v );
		Vector( Vector^ v );
		Vector( Drawing::Color col );
		Vector( float _x, float _y, float _z );
		Vector( float _x, float _y, float _z, float _w );

		[Description( L"XWw肵܂B" )]
		property float X
		{
			float get( void );
			void set( float value );
		}

		[Description( L"YWw肵܂B" )]
		property float Y
		{
			float get( void );
			void set( float value );
		}

		[Description( L"ZWw肵܂B" )]
		property float Z
		{
			float get( void );
			void set( float value );
		}

		[Browsable(false)]
		property float W
		{
			float get( void );
			void set( float value );
		}

		void Normalize( void );

		Drawing::Color ToColor( void );
		void FromColor( Drawing::Color col );

		virtual System::String^ ToString() override;

		static Vector^ Parse( System::String^ str );
	};

}}}
