#pragma once

#include "Mix/Tool/Win32/Core/Dynamics/Joint.h"

namespace Mix{ namespace Tool{ namespace Win32{ namespace Dynamics{

	class BallJoint : public Mix::Tool::Win32::Dynamics::Joint
	{
	public:
		enum PARAM_TYPE
		{
			PT_ERP = 1,
			PT_CFM = 3,
		};

		enum PARAM_AXIS
		{
			PA_TRANSLATION	= 0,
			PA_ROTATION		= 3,
		};

		//p[^̑gݍ킹
		//
		//PT_ERP PA_TRANSLATION ( 1 * ( 0 + 1 ) ) = 1
		//PT_ERP PA_ROTATION    ( 1 * ( 3 + 1 ) ) = 4
		//PT_CFM PA_TRANSLATION ( 3 * ( 0 + 1 ) ) = 3
		//PT_CFM PA_ROTATION    ( 3 * ( 3 + 1 ) ) = 12

	public:
		virtual ~BallJoint( void ) {}

		virtual const D3DXVECTOR3& GetNormalizeSwingAxis( void ) const = 0;
		virtual const D3DXVECTOR3& GetSwingAxis( void ) const = 0;
		virtual void SetSwingAxis( const D3DXVECTOR3& axis ) = 0;

		virtual const D3DXVECTOR3& GetNormalizeTwistAxis( void ) const = 0;
		virtual const D3DXVECTOR3& GetTwistAxis( void ) const = 0;
		virtual void SetTwistAxis( const D3DXVECTOR3& axis ) = 0;

		virtual float GetSwingLimit1( void ) const = 0;
		virtual void SetSwingLimit1( float rad ) = 0;

		virtual float GetSwingLimit2( void ) const = 0;
		virtual void SetSwingLimit2( float rad ) = 0;

		virtual float GetTwistLimit( void ) const = 0;
		virtual void SetTwistLimit( float rad ) = 0;

		virtual float GetSpring( void ) const = 0;
		virtual void SetSpring( float value ) = 0;

		virtual float GetDamper( void ) const = 0;
		virtual void SetDamper( float value ) = 0;

		virtual float GetLimitSpring( void ) const = 0;
		virtual void SetLimitSpring( float value ) = 0;

		virtual float GetLimitDamper( void ) const = 0;
		virtual void SetLimitDamper( float value ) = 0;

	public:
		MIX_OBJECT_TYPE( Mix::Tool::Win32::Object::DYNAMICS__BALL_JOINT, Mix::Tool::Win32::Dynamics::Joint )
	};

}}}}
